/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class Version63Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version63Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version63Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qNamen).where(qNamen.iseigenname.isTrue())).fetch();
        if (Check.isEmpty(list)) {
            return;
        }
        String string = "^([A-Z]{1}[a-zA-Z' ]{1,30}(( |-)?(Stern|star|Star|Stone|Nebula|Nebel|Galaxie|Galaxy|haufen|Sternhaufen|cluster|Cluster|Association|variable|Variable|Wolke|Cloud|Zwerggalaxie)+)+( (A|B|C))?( (b|c|d|e|f|g|h|i))?)|([0-9]{2} [A-Za-z]{3,15} (cluster|Cluster|Association|Sternhaufen)+)|([A-Z]{1}[a-z']{1,16}( (A|B|C))?)|((?!Alpha|Beta|Gamma|Delta|Epsilon|Zeta|Eta|Theta|Iota|Kappa|Lambda|My|Mu|Ny|Nu|Xi|Ksi|Omikron|Omicron|Pi|Rho|Sigma|Tau|Ypsilon|Upsilon|Phi|Chi|Psi|Omega)[A-Z]{1}[a-z]{1,12}( (al|of))? [A-Z]{1}[a-z]{1,16})";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Namen namen : list) {
            if (Pattern.matches(string, namen.getNamen())) continue;
            LOGGER.debug("name " + namen.getNamen() + " ist kein eigenname");
            arrayList.add(namen.getNamen());
        }
        LOGGER.debug("insgesamt " + arrayList.size() + " namen gefunden die jetzt korrigiert werden...");
        long l = ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qNamen).set((Path)qNamen.iseigenname, (Object)false)).where((Predicate)qNamen.namen.in(arrayList))).execute();
        LOGGER.debug(l + " rows updated");
    }

    @Override
    public int updateToVersion() {
        return 63;
    }
}

