/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;

public final class Version65Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version65Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version65Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).fetchCount();
        if (l < 20000L) {
            return;
        }
        FileUtils.deleteQuietly(new File("lib" + File.separator + "window.jar"));
        for (String string : Arrays.asList("namen.txt", "namen2.txt", "namen3.txt", "namen4.txt")) {
            FileUtils.deleteQuietly(new File("temp" + File.separator + string));
        }
    }

    @Override
    public int updateToVersion() {
        return 65;
    }
}

