/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.repos.HabitableZoneRepository;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version66Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version66Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version66Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        try {
            this.datenbankverbinder.query("CREATE CACHED TABLE habitable_zone (id IDENTITY, datenid INTEGER NOT NULL UNIQUE, inner_hz DOUBLE NOT NULL, outer_hz DOUBLE NOT NULL, FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
        }
        catch (SQLException sQLException) {
            LOGGER.debug("Tabelle habitable_zone bereits vorhanden");
            return;
        }
        QDaten qDaten = new QDaten("sterne");
        QDaten qDaten2 = new QDaten("planeten");
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QKategorie qKategorie = QKategorie.kategorie;
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).fetch();
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName()))))).fetch();
        List list3 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct(new Expression[]{qDaten, qSpektraltyp.typ}).from((Expression<?>)qDaten2)).join((EntityPath)qDaten)).on((Predicate)qDaten.id.eq(qDaten2.zugehoerigkeit))).join((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).where(qDaten2.objektid.in(list).and(qDaten.objektid.in(list2)))).fetch();
        LOGGER.debug("berechne HZ f\u00fcr " + list3.size() + " Sterne mit Planeten");
        if (list3.isEmpty()) {
            LOGGER.error("keine Sterne mit Planeten gefunden", null);
            return;
        }
        HabitableZoneRepository habitableZoneRepository = new HabitableZoneRepository(this.datenbankverbinder);
        for (Tuple tuple : list3) {
            try {
                IPlanetensucheObjekt iPlanetensucheObjekt = this.transformTo(tuple);
                habitableZoneRepository.calculateAndSave(iPlanetensucheObjekt);
            }
            catch (RuntimeException | SQLException exception) {
                LOGGER.warn("kann HZ f\u00fcr Stern mit id " + tuple.get(qDaten).getId() + " nicht berechnen", exception);
            }
        }
        LOGGER.debug("migration habitable zonen berechnen fertig");
    }

    @Override
    public int updateToVersion() {
        return 66;
    }

    private IPlanetensucheObjekt transformTo(Tuple tuple) throws SQLException {
        QDaten qDaten = new QDaten("sterne");
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        Daten daten = tuple.get(qDaten);
        PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
        planetensucheObjekt.setKategorie(ObjektKategorie.STERNE.getKategorienName());
        planetensucheObjekt.setDatenid(daten.getId());
        planetensucheObjekt.setSpektralklasse(tuple.get(qSpektraltyp.typ));
        if (daten.getEntfernung() != null) {
            planetensucheObjekt.setEntfernung(daten.getEntfernung());
        }
        if (daten.getMasse() != null) {
            planetensucheObjekt.setMasse(daten.getMasse());
        }
        if (daten.getDurchmesser() != null) {
            planetensucheObjekt.setDurchmesser(daten.getDurchmesser());
        }
        if (daten.getTemperatur() != null) {
            planetensucheObjekt.setTemperatur(daten.getTemperatur());
        }
        if (daten.getSh() != null) {
            planetensucheObjekt.setScheinbareHelligkeit(daten.getSh());
        }
        if (daten.getAh() != null) {
            planetensucheObjekt.setAbsoluteHelligkeit(daten.getAh());
        }
        if (daten.getBv() != null) {
            planetensucheObjekt.setBV(daten.getBv());
        }
        return planetensucheObjekt;
    }
}

