/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version67Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version67Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version67Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(EntdeckerProjekte.COCONUTS.getNameInDatabase()))).fetchFirst();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("COol Companions ON Ultrawide orbiTS (COCONUTS) survey");
            entdecker.setNachname(EntdeckerProjekte.COCONUTS.getNameInDatabase());
            entdecker.setVorname("");
            entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
            this.insertDiscoverer(entdecker);
        }
        if ((entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Zhang"))).fetchFirst()) == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("exoplanet hunter");
            entdecker.setNachname("Zhang");
            entdecker.setVorname("Zhoujian");
            entdecker.setTyp(EntdeckerTyp.PERSON.getType());
            this.insertDiscoverer(entdecker);
        }
    }

    @Override
    public int updateToVersion() {
        return 67;
    }

    private void insertDiscoverer(Entdecker entdecker) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).executeWithKey(qEntdecker.id);
        entdecker.setId(n);
    }
}

