/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.datenbankkern.querydsl5.Ztentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.Arrays;
import java.util.List;

public final class Version69Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version69Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version69Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        try {
            this.datenbankverbinder.query("ALTER TABLE daten ADD COLUMN entdeckungsjahr INTEGER;");
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            LOGGER.debug("spalte entdeckungsjahr existiert schon: " + sQLSyntaxErrorException.getMessage());
        }
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS.getNameInDatabase()))).fetchOne();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("a Zooniverse project");
            entdecker.setNachname(EntdeckerProjekte.PLANET_HUNTERS.getNameInDatabase());
            entdecker.setVorname("");
            entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
            this.insertDiscoverer(entdecker);
        }
        if ((entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase()))).fetchOne()) == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("a Zooniverse project");
            entdecker.setNachname(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase());
            entdecker.setVorname("");
            entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
            this.insertDiscoverer(entdecker);
        }
        if ((entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(EntdeckerProjekte.EXOPLANET_EXPLORERS.getNameInDatabase()))).fetchOne()) == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("a Zooniverse project");
            entdecker.setNachname(EntdeckerProjekte.EXOPLANET_EXPLORERS.getNameInDatabase());
            entdecker.setVorname("");
            entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
            this.insertDiscoverer(entdecker);
        }
        if ((entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Eisner"))).fetchOne()) == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("exoplanet hunter");
            entdecker.setNachname("Eisner");
            entdecker.setVorname("Nora");
            entdecker.setTyp(EntdeckerTyp.PERSON.getType());
            this.insertDiscoverer(entdecker);
        }
        if ((entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Becker"))).fetchOne()) == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("exoplanet hunter");
            entdecker.setNachname("Becker");
            entdecker.setVorname("Juliette");
            entdecker.setTyp(EntdeckerTyp.PERSON.getType());
            this.insertDiscoverer(entdecker);
        }
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(EntdeckerProjekte.EXOPLANET_EXPLORERS.getNameInDatabase()))).fetchOne();
        List<String> list = Arrays.asList("b", "c", "d", "e", "f", "g");
        for (String object62 : list) {
            object5 = this.helper.readPlanetensucheObject("K2-138 " + object62);
            if (object5 == null) continue;
            object4 = new Ztentdecker();
            ((Ztentdecker)object4).setDatenid(((Daten)object5).getId());
            ((Ztentdecker)object4).setEntdeckerid(n);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(object4)).execute();
        }
        Object object7 = this.helper.readPlanetensucheObject("K2-288 B b");
        if (object7 != null) {
            Ztentdecker ztentdecker = new Ztentdecker();
            ztentdecker.setDatenid(((Daten)object7).getId());
            ztentdecker.setEntdeckerid(n);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(ztentdecker)).execute();
        }
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS.getNameInDatabase()))).fetchOne();
        object5 = Arrays.asList("WASP-47 d", "WASP-47 e", "PH1 b", "PH2 b", "Kepler-289 c");
        object4 = object5.iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            object7 = this.helper.readPlanetensucheObject((String)object3);
            if (object7 == null) continue;
            object2 = new Ztentdecker();
            ((Ztentdecker)object2).setDatenid(((Daten)object7).getId());
            ((Ztentdecker)object2).setEntdeckerid(n2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(object2)).execute();
        }
        object4 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq("Becker"))).fetchOne();
        object5 = Arrays.asList("WASP-47 d", "WASP-47 e");
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object7 = this.helper.readPlanetensucheObject((String)object2);
            if (object7 == null) continue;
            object = new Ztentdecker();
            ((Ztentdecker)object).setDatenid(((Daten)object7).getId());
            ((Ztentdecker)object).setEntdeckerid((Integer)object4);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(object)).execute();
        }
        object3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(EntdeckerProjekte.PLANET_HUNTERS_TESS.getNameInDatabase()))).fetchOne();
        object2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq("Eisner"))).fetchOne();
        object5 = Arrays.asList("HD 152843 b", "HD 152843 c", "TOI-813 b", "TOI-1338 b");
        object = object5.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            object7 = this.helper.readPlanetensucheObject(string);
            if (object7 == null) continue;
            Ztentdecker ztentdecker = new Ztentdecker();
            ztentdecker.setDatenid(((Daten)object7).getId());
            ztentdecker.setEntdeckerid((Integer)object3);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(ztentdecker)).execute();
            ztentdecker = new Ztentdecker();
            ztentdecker.setDatenid(((Daten)object7).getId());
            ztentdecker.setEntdeckerid((Integer)object2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(ztentdecker)).execute();
        }
    }

    @Override
    public int updateToVersion() {
        return 69;
    }

    private void insertDiscoverer(Entdecker entdecker) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).executeWithKey(qEntdecker.id);
        entdecker.setId(n);
    }
}

