/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version6Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version6Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper migrationHelper;

    @Inject
    public Version6Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.migrationHelper = new MigrationHelper(this.datenbankverbinder);
    }

    @Override
    public int updateToVersion() {
        return 6;
    }

    @Override
    public void update() {
        Object object;
        Object object2;
        Object object3;
        RelationalPathBase relationalPathBase;
        LOGGER.info("update Datenbank von Version 5 auf 6...");
        try {
            relationalPathBase = QKategorie.kategorie;
            object3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)relationalPathBase.id).from((Expression<?>)relationalPathBase)).where(relationalPathBase.name.eq("Sterne"))).fetchFirst();
            object2 = QSpektraltyp.spektraltyp;
            object = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)((QSpektraltyp)object2).id).from((Expression<?>)object2)).where(((QSpektraltyp)object2).kid.eq((Integer)object3).and(((QSpektraltyp)object2).typ.eq("L")))).fetchFirst();
            if (object == null) {
                ((SQLInsertClause)((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause((RelationalPath<?>)object2).columns(new Path[]{((QSpektraltyp)object2).kid, ((QSpektraltyp)object2).typ})).values(new Object[]{object3, "L"})).execute();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim Hinzuf\u00fcgen des Spektraltyps L zu Sternen", sQLException);
        }
        try {
            relationalPathBase = QEntdecker.entdecker;
            object3 = (Entdecker)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)relationalPathBase).from((Expression<?>)relationalPathBase)).where(((QEntdecker)relationalPathBase).nachname.eq("Mc Cullogh"))).fetchFirst();
            if (object3 != null) {
                ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(relationalPathBase).set((Path)((QEntdecker)relationalPathBase).nachname, "McCullough")).set((Path)((QEntdecker)relationalPathBase).vorname, "Peter")).where((Predicate)((QEntdecker)relationalPathBase).id.eq(((Entdecker)object3).getId()))).execute();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim Korrigieren des Entdeckernamens Mc Cullogh", sQLException);
        }
        try {
            relationalPathBase = QObjekttypen.objekttypen;
            object3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)((QObjekttypen)relationalPathBase).id).from((Expression<?>)relationalPathBase)).where(((QObjekttypen)relationalPathBase).typ.eq("Brauner Zwerg"))).fetchFirst();
            object2 = this.migrationHelper.readPlanetensucheObject("HD 16760 b");
            if (object2 != null) {
                ((Daten)object2).setMasse(280.0);
                ((Daten)object2).setObjektid((Integer)object3);
                this.migrationHelper.updatePlanetensucheObjekt((Daten)object2);
            }
            if ((object = this.migrationHelper.readPlanetensucheObject("HD 5388 b")) != null) {
                ((Daten)object).setMasse(69.0);
                ((Daten)object).setObjektid((Integer)object3);
                this.migrationHelper.updatePlanetensucheObjekt((Daten)object);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim Korrigieren von Exoplaneten", sQLException);
        }
    }
}

