/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public final class Version70Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version70Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version70Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        List<String> list = Arrays.asList("Kepler Science Team", "TESS Project");
        for (String string : list) {
            Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq(string).and(qEntdecker.typ.eq(EntdeckerTyp.PROJECT.getType())))).fetchOne();
            if (entdecker == null) continue;
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZtentdecker).where((Predicate)qZtentdecker.entdeckerid.eq(entdecker.getId()))).execute();
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qEntdecker).where((Predicate)qEntdecker.id.eq(entdecker.getId()))).execute();
        }
    }

    @Override
    public int updateToVersion() {
        return 70;
    }
}

