/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.datenbankkern.querydsl5.Ztentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public final class Version71Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version71Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version71Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        Object object;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        Entdecker entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Rosenthal"))).fetchOne();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("exoplanet hunter");
            entdecker.setNachname("Rosenthal");
            entdecker.setVorname("Lee J.");
            entdecker.setTyp(EntdeckerTyp.PERSON.getType());
            this.insertDiscoverer(entdecker);
        }
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(EntdeckerProjekte.CALIFORNIA.getNameInDatabase()))).fetchOne();
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq("Rosenthal"))).fetchOne();
        List<String> list = Arrays.asList("HD 107148 c", "HD 136925 b", "HD 141004 b", "HD 145675 c", "HD 156668 c", "HD 164922 e", "HD 168009 b", "HD 213472 b", "HD 24040 c", "HD 26161 b", "HD 3765 b", "HD 66428 c", "HD 68988 c", "HD 95735 c");
        for (String object2 : list) {
            Daten daten = this.helper.readPlanetensucheObject(object2);
            if (daten == null) continue;
            object = new Ztentdecker();
            ((Ztentdecker)object).setDatenid(daten.getId());
            ((Ztentdecker)object).setEntdeckerid(n);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(object)).execute();
            object = new Ztentdecker();
            ((Ztentdecker)object).setDatenid(daten.getId());
            ((Ztentdecker)object).setEntdeckerid(n2);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(object)).execute();
        }
        entdecker = (Entdecker)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qEntdecker).where(qEntdecker.nachname.eq("Castro Gonzalez"))).fetchOne();
        if (entdecker == null) {
            entdecker = new Entdecker();
            entdecker.setFachgebiet("exoplanet hunter");
            entdecker.setNachname("Castro Gonzalez");
            entdecker.setVorname("A.");
            entdecker.setTyp(EntdeckerTyp.PERSON.getType());
            this.insertDiscoverer(entdecker);
        }
        Integer n3 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq("Castro Gonzalez"))).fetchOne();
        list = Arrays.asList("K2-316 b", "K2-316 c", "K2-317 b", "K2-318 b", "K2-319 b", "K2-320 b", "K2-321 b", "K2-322 b", "K2-323 b", "K2-324 b", "K2-325 b", "K2-326 b");
        for (String string : list) {
            object = this.helper.readPlanetensucheObject(string);
            if (object == null) continue;
            Ztentdecker ztentdecker = new Ztentdecker();
            ztentdecker.setDatenid(((Daten)object).getId());
            ztentdecker.setEntdeckerid(n3);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(ztentdecker)).execute();
        }
    }

    @Override
    public int updateToVersion() {
        return 71;
    }

    private void insertDiscoverer(Entdecker entdecker) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).executeWithKey(qEntdecker.id);
        entdecker.setId(n);
    }
}

