/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.impl.EntdeckermappingService;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerWeltraumteleskope;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.datenbankkern.querydsl5.Ztentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Version72Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version72Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version72Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qEntdecker).set((Path)qEntdecker.vorname, "Fei")).where((Predicate)qEntdecker.nachname.eq("Dai"))).execute();
        List<String> list = Arrays.asList("HD 109286 b", "HD 115954 b", "HD 211403 b", "HD 27969 b", "HD 80869 b", "HD 95544 b", "L 98-59 e", "WASP-151 b", "WASP-153 b", "WASP-156 b");
        this.helper.addPlanetsToDiscoverer("Olivier", "Demangeon", list);
        list = Arrays.asList("BD-11 4672 c", "HD 126525 b", "HD 220197 b", "HD 233832 b");
        this.helper.addPlanetsToDiscoverer("Domenico", "Barbato", list);
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.NGTS, "NGTS is a ground-based robotic search for exoplanets", null);
        this.helper.addPlanetsToSpaceTelescope(EntdeckerWeltraumteleskope.TESS, "space telescope to find exoplanets by transit method", null);
        this.helper.addPlanetsToDiscoverer("Timothy", "Morton", null);
        try {
            EntdeckermappingService entdeckermappingService = new EntdeckermappingService();
            IPlanetensucheObjektRepository iPlanetensucheObjektRepository = BeanFactory.getInjector().getInstance(IPlanetensucheObjektRepository.class);
            IKategorienRepository iKategorienRepository = BeanFactory.getInjector().getInstance(IKategorienRepository.class);
            List<Integer> list2 = iKategorienRepository.getDatenidsFuerKategorie(ObjektKategorie.PLANETEN.getKategorienName());
            List<IPlanetensucheObjekt> list3 = iPlanetensucheObjektRepository.read(list2);
            for (IPlanetensucheObjekt iPlanetensucheObjekt : list3) {
                HashMap<String, String> hashMap = new HashMap<String, String>(iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen());
                entdeckermappingService.ermittleUndSetzeEntdecker(iPlanetensucheObjekt);
                MapDifference<String, String> mapDifference = Maps.difference(hashMap, iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen());
                if (mapDifference.areEqual()) continue;
                Map<String, String> map = mapDifference.entriesOnlyOnRight();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    LOGGER.debug("versuche " + iPlanetensucheObjekt.getObjektNamen().toString() + " mit Entdecker " + entry.toString() + " zu verbinden");
                    Integer n = entry.getValue() != null ? (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(entry.getKey()).and(qEntdecker.vorname.eq(entry.getValue())))).fetchOne() : (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(entry.getKey()).and(qEntdecker.vorname.isEmpty().or(qEntdecker.vorname.isNull())))).fetchOne();
                    if (n == null) {
                        LOGGER.warn("kein Entdecker gefunden f\u00fcr " + entry.toString());
                        continue;
                    }
                    Ztentdecker ztentdecker = new Ztentdecker();
                    ztentdecker.setDatenid(iPlanetensucheObjekt.getDatenid());
                    ztentdecker.setEntdeckerid(n);
                    ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qZtentdecker).populate(ztentdecker)).execute();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            throw new SQLException(iOException);
        }
    }

    @Override
    public int updateToVersion() {
        return 72;
    }
}

