/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public final class Version73Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version73Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version73Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        List<String> list = Arrays.asList("G 264-012 b", "G 264-012 c", "GJ 1148 c", "GJ 1265 b", "GJ 338 B b", "GJ 3512 b", "GJ 3779 b", "GJ 4276 b", "GJ 486 b", "HD 147379 b", "HD 180617 b", "LSPM J2116+0234 b", "Teegarden's Star b", "Teegarden's Star c");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.CARMENES, "Calar Alto high-Resolution search for M dwarfs with Exoearths with Near-infrared and optical Echelle Spectrographs", list);
        list = Arrays.asList("Kepler-539 c");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.EDEN, "ExoEarth Discovery and Exploration Network", list);
        list = Arrays.asList("HD 213885 b", "TOI-481 b", "TOI-892 b");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.WINE, "Warm Gigants with TESS", list);
    }

    @Override
    public int updateToVersion() {
        return 73;
    }
}

