/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Version75Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version75Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version75Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        List<String> list = Arrays.asList("KPS-1 b");
        this.helper.addPlanetsToDiscoverer("Artem Y.", "Burdanov", list);
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.KPS, "Kourovka Planet Search (KPS)", list);
        list = Arrays.asList("GPX-1 b");
        this.helper.addPlanetsToDiscoverer("Paul", "Benni", list);
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.GPX, "Galactic Plane eXoplanet (GPX) survey", list);
        list = Arrays.asList("YSES 2 b");
        this.helper.addPlanetsToDiscoverer("Alexander J.", "Bohn", list);
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.YSES, "the Young Suns Exoplanet Survey (YSES)", list);
        list = Arrays.asList("LHS 3844 b", "TOI-125 b", "TOI-125 c", "HD 21749 c", "LP 791-18 b", "LP 791-18 c", "TOI-1130 b", "TOI-1130 c", "GJ 1252 b", "HR 858 b", "HR 858 c", "HR 858 d", "WD 1856+534 b", "TOI-1333 b", "TOI-1478 b", "TOI-1601 b", "TOI-172 b", "TOI-628 b", "TOI-640 b", "HD 108236 b", "HD 108236 c", "HD 108236 d", "HD 108236 e", "TOI-1231 b", "TOI-824 b", "TOI-270 b");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.TESS_SCIENCE_OFFICE, "Transiting Exoplanet Survey Satellite Science Office (TSO)", list);
        list = Arrays.asList("HD 21749 c");
        this.helper.addPlanetsToDiscoverer("Diana", "Dragomir", list);
        list = Arrays.asList("TOI-1130 b", "TOI-1130 c");
        this.helper.addPlanetsToDiscoverer("Chelsea", "Huang", list);
        list = Arrays.asList("TOI-1333 b", "TOI-1478 b", "TOI-1601 b", "TOI-172 b", "TOI-628 b", "TOI-640 b");
        this.helper.addPlanetsToDiscoverer("Joseph", "Rodriguez", list);
        list = Arrays.asList("HD 108236 b", "HD 108236 c", "HD 108236 d", "HD 108236 e");
        this.helper.addPlanetsToDiscoverer("Tansu", "Daylan", list);
        list = Arrays.asList("LHS 3844 b");
        this.helper.addPlanetsToDiscoverer("Roland", "Vanderspek", list);
        list = Arrays.asList("KOI-13 b", "Kepler-22 b", "Kepler-4 b", "Kepler-62 b", "Kepler-62 c", "Kepler-62 d", "Kepler-62 e", "Kepler-62 f");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.KEPLER_K2_TEAM, "Kepler and K2 Team", list);
        list = Arrays.asList("HD 22496 b", "HD 5278 c");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.ESPRESSO, "Echelle SPectrograph for Rocky Exoplanet and Stable Spectroscopic Observations (ESPRESSO) consortium", list);
        list = Arrays.asList("BD,15 2375 b", "BD-06 1339 b", "BD-06 1339 c", "BD-08 2823 b", "BD-08 2823 c", "BD-11 4672 b", "BD-11 4672 c", "BD-17 63 b", "DMPP-1 b", "DMPP-1 c", "DMPP-1 d", "DMPP-1 e", "DMPP-3 A b", "GJ 1061 b", "GJ 1061 c", "GJ 1061 d", "GJ 1132 c", "GJ 15 A c", "GJ 163 b", "GJ 163 c", "GJ 163 d", "GJ 273 b", "GJ 273 c", "GJ 3138 b", "GJ 3138 c", "GJ 3138 d", "GJ 3293 b", "GJ 3293 c", "GJ 3293 d", "GJ 3293 e", "GJ 3323 b", "GJ 3323 c", "GJ 3341 b", "GJ 3470 b", "GJ 3634 b", "GJ 3942 b", "GJ 3998 b", "GJ 3998 c", "GJ 433 b", "GJ 536 b", "GJ 581 b", "GJ 581 c", "GJ 581 e", "GJ 667 C b", "GJ 667 C c", "GJ 667 C e", "GJ 667 C f", "GJ 667 C g", "GJ 674 b", "GJ 676 A b", "GJ 676 A d", "GJ 676 A e", "GJ 720 A b", "GJ 887 b", "GJ 887 c", "Gl 686 b", "HD 100777 b", "HD 10180 c", "HD 10180 d", "HD 10180 e", "HD 10180 f", "HD 10180 g", "HD 10180 h", "HD 101930 b", "HD 102117 b", "HD 103197 b", "HD 103720 b", "HD 103774 b", "HD 104067 b", "HD 108341 b", "HD 109271 b", "HD 109271 c", "HD 110113 c", "HD 111998 b", "HD 113538 b", "HD 113538 c", "HD 125595 b", "HD 125612 c", "HD 125612 d", "HD 126525 b", "HD 131664 b", "HD 134060 b", "HD 134060 c", "HD 136352 b", "HD 136352 c", "HD 136352 d", "HD 137388 b", "HD 13808 b", "HD 13808 c", "HD 145377 b", "HD 1461 c", "HD 148156 b", "HD 153950 b", "HD 156411 b", "HD 160691 d", "HD 160691 e", "HD 164922 d", "HD 1690 b", "HD 171028 b", "HD 175607 b", "HD 177565 b", "HD 181433 b", "HD 181433 c", "HD 181433 d", "HD 181720 b", "HD 190647 b", "HD 190984 b", "HD 192310 b", "HD 192310 c", "HD 20003 b", "HD 20003 c", "HD 204941 b", "HD 20781 b", "HD 20781 c", "HD 20781 d", "HD 20781 e", "HD 20794 b", "HD 20794 c", "HD 20794 d", "HD 20794 e", "HD 20868 b", "HD 212301 b", "HD 215152 b", "HD 215152 c", "HD 215152 d", "HD 215152 e", "HD 215497 b", "HD 215497 c", "HD 21693 b", "HD 21693 c", "HD 217786 b", "HD 219134 b", "HD 219134 c", "HD 219134 d", "HD 219134 h", "HD 219828 b", "HD 220197 b", "HD 221287 b", "HD 233832 b", "HD 25171 b", "HD 2638 b", "HD 27894 b", "HD 27894 c", "HD 27894 d", "HD 28254 b", "HD 285968 b", "HD 290327 b", "HD 30669 b", "HD 31527 b", "HD 31527 c", "HD 31527 d", "HD 330075 b", "HD 40307 b", "HD 40307 c", "HD 40307 d", "HD 40307 f", "HD 40307 g", "HD 4308 b", "HD 43197 b", "HD 44219 b", "HD 45184 b", "HD 45184 c", "HD 45364 b", "HD 45364 c", "HD 47186 b", "HD 47186 c", "HD 51608 b", "HD 51608 c", "HD 5583 b", "HD 564 b", "HD 60532 b", "HD 60532 c", "HD 63454 b", "HD 63765 b", "HD 65216 c", "HD 6718 b", "HD 69830 b", "HD 69830 c", "HD 69830 d", "HD 7199 b", "HD 73267 b", "HD 7449 b", "HD 77338 b", "HD 8535 b", "HD 85390 b", "HD 85512 b", "HD 90156 b", "HD 93083 b", "HIP 12961 b", "HIP 5158 b", "HIP 5158 c", "HIP 70849 b", "IC 4651 9122 b", "K2-18 c", "Kepler-19 d", "NGC 2682 YBP 401 b", "Pr0211 c", "Ross 128 b", "TYC 4282-00605-1 b", "Wolf 1061 b", "Wolf 1061 c", "Wolf 1061 d", "XO-2 S b", "XO-2 S c", "YZ Cet b", "YZ Cet c", "YZ Cet d", "bet Pic c", "eps Ind A b");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.HARPS, "High Accuracy Radial velocity Planetary Search project (HARPS) / north (HARPS-N)", list);
        list = Arrays.asList("HIP 79098 AB b", "PDS 70 b", "TYC 8998-760-1 b", "TYC 8998-760-1 c", "YSES 2 b");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.SPHERE, "Spectro Polarimetric High contrast Exoplanet REsearch (SPHERE) project", list);
        list = new ArrayList<String>();
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.NIRPS, "Near Infra Red Planet Searcher (NIRPS) project", list);
        list = Arrays.asList("BD-13 2130 b", "GJ 3021 b", "GJ 86 b", "HD 106515 A b", "HD 108147 b", "HD 111232 b", "HD 114386 b", "HD 121504 b", "HD 130322 b", "HD 141937 b", "HD 142022 A b", "HD 142415 b", "HD 147018 b", "HD 147018 c", "HD 147513 b", "HD 156846 b", "HD 162020 b", "HD 166724 b", "HD 168746 b", "HD 169830 b", "HD 169830 c", "HD 171238 b", "HD 181234 b", "HD 192263 b", "HD 196067 b", "HD 19994 b", "HD 202206 c", "HD 204313 b", "HD 213240 b", "HD 216770 b", "HD 219077 b", "HD 220689 b", "HD 25015 b", "HD 27631 b", "HD 28185 b", "HD 41004 A b", "HD 41004 B b", "HD 4113 b", "HD 50499 c", "HD 6434 b", "HD 65216 b", "HD 75289 b", "HD 82943 b", "HD 82943 c", "HD 92788 c", "HD 92987 b", "HD 98649 b", "WASP-41 c", "WASP-47 c");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.CORALIE, "CORALIE planet-search survey", list);
    }

    @Override
    public int updateToVersion() {
        return 75;
    }
}

