/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.List;

public final class Version76Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version76Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version76Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        try {
            this.datenbankverbinder.query("ALTER TABLE daten ADD COLUMN entdeckungsjahr INTEGER;");
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            LOGGER.info("spalte entdeckungsjahr existiert schon: " + sQLSyntaxErrorException.getMessage());
        }
        QDaten qDaten = QDaten.daten;
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)qDaten).where(qDaten.entdeckungsdatum.isNotEmpty())).fetch();
        for (Daten daten : list) {
            try {
                int n = Integer.parseInt(daten.getEntdeckungsdatum().substring(daten.getEntdeckungsdatum().length() - 4));
                daten.setEntdeckungsjahr(n);
                this.helper.updatePlanetensucheObjekt(daten);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.warn("Entdeckungsdatum '" + daten.getEntdeckungsdatum() + "' ung\u00fcltig/nicht erkannt");
            }
        }
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.DMPP, "find interessting exoplanets for detailed study", null);
    }

    @Override
    public int updateToVersion() {
        return 76;
    }
}

