/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version77Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version77Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version77Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.addPlanetsToDiscoverer("Isabel", "Angelo", Arrays.asList("Kepler-1649 b"));
        this.helper.addPlanetsToDiscoverer("Benjamin", "Pope", Arrays.asList("EPIC 212297394 c", "K2-330 b", "K2-332 b", "K2-335 b", "K2-336 b", "K2-337 b", "K2-338 b", "K2-340 b", "K2-345 b", "K2-346 b", "K2-347 b", "K2-349 b", "K2-350 c", "K2-354 b"));
        this.helper.addPlanetsToDiscoverer("N.", "Unger", Arrays.asList("HD 154088 b", "HD 189567 b", "HD 189567 c", "HD 39194 b", "HD 39194 c", "HD 39194 d", "HD 93385 b", "HD 93385 c", "HD 93385 d", "HD 96700 b", "HD 96700 c", "HD 96700 d"));
        this.helper.addPlanetsToDiscoverer("Liang", "Yu", Arrays.asList("TAP 26 b", "EPIC 246851721 b", "K2-331 c", "K2-333 b", "K2-334 b", "K2-342 b", "K2-343 c", "K2-344 b", "K2-348 b", "K2-348 c", "K2-352 c", "K2-352 d"));
        this.helper.addPlanetsToDiscoverer("Youn Kil", "Jung", Arrays.asList("KMT-2016-BLG-1820L b", "KMT-2016-BLG-2142L b", "KMT-2017-BLG-0165L b", "KMT-2019-BLG-0842L b", "OGLE-2013-BLG-0102L b", "OGLE-2017-BLG-1522L b", "OGLE-2018-BLG-0567L b", "OGLE-2018-BLG-0596L b", "OGLE-2018-BLG-0962L b", "OGLE-2018-BLG-1269L b"));
        this.helper.addPlanetsToDiscoverer("S.", "Dalal", Arrays.asList("BD+45 564 b", "BD+55 362 b", "BD+63 1405 b", "BD-00 4475 b", "HD 124330 b", "HD 155193 b", "HD 331093 b"));
        this.helper.addPlanetsToDiscoverer("Christina", "Hedges", Arrays.asList("K2-198 c", "K2-198 d", "K2-43 c", "TOI-1807 b", "TOI-2076 b", "TOI-2076 c", "TOI-2076 d"));
    }

    @Override
    public int updateToVersion() {
        return 77;
    }
}

