/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public final class Version78Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version78Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version78Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.addPlanetsToDiscoverer("Kristine", "Lam", Arrays.asList("GJ 367 b", "K2-265 b", "WASP-127 b", "WASP-136 b", "WASP-138 b"));
        this.helper.addPlanetsToDiscoverer("Szilard", "Csizmadia", Arrays.asList("CoRoT-17 b"));
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.DLR_INSTITUT_PLANETENFORSCHUNG, "DLR (German Aerospace Center) Institute of Planetary Research", Arrays.asList("GJ 367 b", "K2-265 b", "WASP-127 b", "WASP-136 b", "WASP-138 b", "CoRoT-17 b"));
        this.helper.addPlanetsToDiscoverer("Gregory", "Olmschenk", Arrays.asList(""));
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.JHU_CAS, "exoplanet research program at Johns Hopkins University/Center for Astrophysical Sciences", Arrays.asList(""));
        List<String> list = Arrays.asList("K2-268 d", "K2-268 e", "K2-268 f", "K2-339 b", "K2-343 b");
        this.helper.addPlanetsToDiscovererProject(EntdeckerProjekte.QATS, "Quasi-periodic Automated Transit Search (transit timing variations (TTVs))", list);
        this.helper.addPlanetsToDiscoverer("Ethan", "Kruse", list);
    }

    @Override
    public int updateToVersion() {
        return 78;
    }
}

