/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;

public final class Version7Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version7Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper migrationHelper;

    @Inject
    public Version7Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.migrationHelper = new MigrationHelper(this.datenbankverbinder);
    }

    @Override
    public int updateToVersion() {
        return 7;
    }

    @Override
    public void update() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Kepler-39");
            arrayList.add("Kepler-39 b");
            arrayList.add("Kepler-81");
            arrayList.add("Kepler-81 b");
            arrayList.add("Kepler-81 c");
            arrayList.add("Kepler-81 d");
            arrayList.add("Kepler-117");
            arrayList.add("Kepler-117 b");
            arrayList.add("Kepler-117 c");
            arrayList.add("Kepler-248");
            arrayList.add("Kepler-248 b");
            arrayList.add("Kepler-248 c");
            arrayList.add("HD 175541");
            arrayList.add("OGLE-2005-BLG-071");
            this.migrationHelper.deletePlanetensucheObjects(arrayList);
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim L\u00f6schen von doppelten Exoplaneten & Sternen", sQLException);
        }
    }
}

