/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version84Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version84Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version84Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-500.01"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-500"));
        this.helper.addNamen("HIP 34269", "TOI-500");
        this.helper.addNamen("HIP 34269", "TIC 134200185");
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-1411.01"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-1411"));
        this.helper.addNamen("HIP 76042", "TOI-1411");
        this.helper.addNamen("HIP 76042", "TIC 116483514");
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-1860.01"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-1860"));
        this.helper.addNamen("HIP 73869", "TOI-1860");
        this.helper.addNamen("HIP 73869", "TIC 202426247");
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-560.01"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-560.02"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-560"));
        this.helper.addNamen("HIP 42401", "TOI-560");
        this.helper.addNamen("HIP 42401", "TIC 101011575");
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-1465.01"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("TOI-1465"));
        this.helper.addNamen("Qatar-1", "TOI-1465");
        this.helper.addNamen("Qatar-1", "TIC 236887394");
        this.helper.addNamen("Qatar-1", "Gaia DR2 2244830490514284928");
        this.helper.renameName("GJ 229 A", "GJ 229");
        this.helper.renameName("TOI-1259", "TOI-1259 A");
    }

    @Override
    public int updateToVersion() {
        return 84;
    }
}

