/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version85Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version85Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    @Inject
    public Version85Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-390 b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-390"));
        this.helper.addNamen("TOI-4549", "EPIC 245995977");
        this.helper.addNamen("TOI-4549", "K2-390");
        this.helper.addNamen("TOI-4549.01", "K2-390 b");
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-405 b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-405"));
        this.helper.addNamen("TOI-5116", "EPIC 248874928");
        this.helper.addNamen("TOI-5116", "K2-405");
        this.helper.addNamen("TOI-5116.01", "K2-405 b");
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-399 b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-399"));
        this.helper.addNamen("TOI-4838", "EPIC 248472140");
        this.helper.addNamen("TOI-4838", "K2-399");
        this.helper.addNamen("TOI-4838.01", "K2-399 b");
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-406 b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-406"));
        this.helper.addNamen("TOI-4630", "EPIC 249223471");
        this.helper.addNamen("TOI-4630", "K2-406");
        this.helper.addNamen("TOI-4630.01", "K2-406 b");
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-403 b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-403"));
        this.helper.addNamen("TIC 365007485", "EPIC 248758353");
        this.helper.addNamen("TIC 365007485", "K2-403");
        this.helper.addNamen("TIC 365007485.01", "K2-403 b");
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-370 b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-370"));
        this.helper.addNamen("TIC 456945304", "EPIC 210797580");
        this.helper.addNamen("TIC 456945304", "K2-370");
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-371 b"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("K2-371"));
        this.helper.addNamen("TIC 366622912", "EPIC 211399359");
        this.helper.addNamen("TIC 366622912", "K2-371");
        this.helper.addNamen("TIC 366622912.01", "K2-371 b");
        this.helper.renameName("GJ 229 A c", "GJ 229 c");
    }

    @Override
    public int updateToVersion() {
        return 85;
    }
}

