/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version87Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version87Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    public Version87Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        try {
            this.datenbankverbinder.query("CREATE TABLE pht_transit_matches (id IDENTITY, planet_id VARCHAR(30) NOT NULL UNIQUE, tic_id BIGINT NOT NULL, epoch_bjd DOUBLE NOT NULL, epoch_bjd_error DOUBLE NOT NULL, period_days DOUBLE, period_days_error DOUBLE, exofop_entry_created TIMESTAMP NOT NULL, checked BOOLEAN DEFAULT false NOT NULL, matched_subject_id BIGINT, exofop_state VARCHAR(10));");
        }
        catch (SQLException sQLException) {
            LOGGER.debug("Tabelle pht_transit_matches bereits vorhanden");
        }
    }

    @Override
    public int updateToVersion() {
        return 87;
    }
}

