/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Arrays;

public final class Version88Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version88Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version88Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        this.helper.deletePlanetensucheObjects(Arrays.asList("TIC 349488688.01"));
        this.helper.deletePlanetensucheObjects(Arrays.asList("TIC 349488688.02"));
        this.helper.addNamen("HD 152843 b", "TIC 349488688.01");
        this.helper.addNamen("HD 152843 c", "TIC 349488688.02");
        this.helper.addNamen("HD 152843 b", "TOI-2319.01");
        this.helper.addNamen("HD 152843 c", "TOI-2319.02");
    }

    @Override
    public int updateToVersion() {
        return 88;
    }
}

