/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerProjekte;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version8Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version8Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version8Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int updateToVersion() {
        return 8;
    }

    @Override
    public void update() {
        QEntdecker qEntdecker;
        try {
            this.insertEntdecker("Etienne", "Artigau");
            this.insertEntdecker("Andrzej", "Baran");
            this.insertEntdecker("Phil", "Gregory");
            this.insertEntdecker("Grzegorz", "Nowak");
            this.insertEntdecker("M.", "Hernan-Obispo");
            this.insertEntdecker("Davide", "Gandolfi");
            this.insertEntdecker("Marc", "Ollivier");
            this.insertEntdecker("Daniel", "Rouan");
            this.insertEntdecker("Jose Manuel", "Almenara");
            this.insertEntdecker("Hannu", "Parviainen");
            this.insertEntdecker("Suzanne", "Aigrain");
            this.insertEntdecker("Heike", "Rauer");
            this.insertEntdecker("Alain", "Leger");
            this.insertEntdecker("Hans-Joerg", "Deeg");
            this.insertEntdecker("Johannes", "Sahlmann");
            this.insertEntdecker("Y.", "Itoh");
            this.insertEntdecker("Paul", "Robertson");
            this.insertEntdecker("Nicola", "Astudillo-Defru");
            this.insertEntdecker("Masayuki", "Kuzuhara");
            this.insertEntdecker("Guillem", "Anglada-Escude");
            this.insertEntdecker("Mikko", "Tuomi");
            this.insertEntdecker("Jennifer", "Burt");
            this.insertEntdecker("Marie-Eve", "Naud");
            this.insertEntdecker("B.", "Beky");
            this.insertEntdecker("Allyson", "Bieryla");
            this.insertEntdecker("Diana", "Juncher");
            this.insertEntdecker("Zi Tao", "Huang");
            this.insertEntdecker("A.", "Pal");
            this.insertEntdecker("Avi", "Shporer");
            this.insertEntdecker("Rafael", "Brahm");
            this.insertEntdecker("Luigi", "Mancini");
            this.insertEntdecker("Maren", "Mohler-Fischer");
            this.insertEntdecker("Andres", "Jordan");
            this.insertEntdecker("Sascha P.", "Quanz");
            this.insertEntdecker("Jian", "Ge");
            this.insertEntdecker("Maxime", "Marmier");
            this.insertEntdecker("J. R.", "De Medeiros");
            this.insertEntdecker("Simon", "Borgniet");
            this.insertEntdecker("Samuli", "Kotiranta");
            this.insertEntdecker("Silvano", "Desidera");
            this.insertEntdecker("Haven", "Giguere");
            this.insertEntdecker("Stanimir", "Metchev");
            this.insertEntdecker("Lynne", "Hillenbrand");
            this.insertEntdecker("Ati", "Motalebi");
            this.insertEntdecker("Sean", "O'Kane");
            this.insertEntdecker("Morgan", "Desort");
            this.insertEntdecker("Benjamin", "Fulton");
            this.insertEntdecker("Julien", "Rameau");
            this.insertEntdecker("Andrew", "Vanderburg");
            this.insertEntdecker("Farhan", "Feroz");
            this.insertEntdecker("Benjamin", "Montet");
            this.insertEntdecker("Ian J. M.", "Crossfield");
            this.insertEntdecker("Karren A.", "Collins");
            this.insertEntdecker("Vincent", "Bourrier");
            this.insertEntdecker("Lauren M.", "Weiss");
            this.insertEntdecker("Natalie M.", "Batalha");
            this.insertEntdecker("Ji-Wei", "Xie");
            this.insertEntdecker("Jonathan J.", "Fortney");
            this.insertEntdecker("Sam", "Hadden");
            this.insertEntdecker("Jean-Michel", "Desert");
            this.insertEntdecker("Jason", "Steffen");
            this.insertEntdecker("Roberto", "Sanchis-Ojeda");
            this.insertEntdecker("Philip Steven", "Muirhead");
            this.insertEntdecker("Jorge", "Lillo-Box");
            this.insertEntdecker("Mark E.", "Everett");
            this.insertEntdecker("Francesca", "Faedi");
            this.insertEntdecker("Elisa", "Quintana");
            this.insertEntdecker("Sarah", "Ballard");
            this.insertEntdecker("Thomas", "Gautier");
            this.insertEntdecker("Thomas", "Barclay");
            this.insertEntdecker("Vincent", "Van Eylen");
            this.insertEntdecker("Rebekah", "Dawson");
            this.insertEntdecker("Simona", "Ciceri");
            this.insertEntdecker("Tiago", "Campante");
            this.insertEntdecker("Simon", "Albrecht");
            this.insertEntdecker("Kento", "Masuda");
            this.insertEntdecker("William", "Chaplin");
            this.insertEntdecker("Soren", "Meibom");
            this.insertEntdecker("Ronald", "Gilliland");
            this.insertEntdecker("Simchon", "Faigler");
            this.insertEntdecker("Aviv", "Ofir");
            this.insertEntdecker("Matthew J.", "Holman");
            this.insertEntdecker("Daisuke", "Suzuki");
            this.insertEntdecker("Y.", "Muraki");
            this.insertEntdecker("Noriyuki", "Miyake");
            this.insertEntdecker("Kei", "Furusawa");
            this.insertEntdecker("Yossi", "Shvartzvald");
            this.insertEntdecker("Anna", "Brucalassi");
            this.insertEntdecker("N.", "Koshimoto");
            this.insertEntdecker("Radek", "Poleski");
            this.insertEntdecker("N.", "Kains");
            this.insertEntdecker("Jan", "Skowron");
            this.insertEntdecker("A.", "Fukui");
            this.insertEntdecker("Steinn", "Sigurdsson");
            this.insertEntdecker("Marta L.", "Bryan");
            this.insertEntdecker("Thayne", "Currie");
            this.insertEntdecker("Victor Sanchez", "Bejar");
            this.insertEntdecker("Stephen B.", "Potter");
            this.insertEntdecker("Bartosz", "Gauza");
            this.insertEntdecker("R.", "Petrucci");
            this.insertEntdecker("Don", "Pollacco");
            this.insertEntdecker("Paul Anthony", "Wilson");
            this.insertEntdecker("Jeremy", "Tregloan-Reed");
            this.insertEntdecker("Y.", "Gomez Maqueo Chew");
            this.insertEntdecker("Laetitia", "Delrez");
            this.insertEntdecker("Heather", "Knutson");
            this.insertEntdecker("Marion", "Neveu-VanMalle");
            this.insertEntdecker("Francesco", "Borsa");
            this.insertEntdecker("Samuel N.", "Quinn");
            this.insertEntdecker("Jonathan J.", "Swift");
            this.insertEntdecker("Jennifer", "Yee");
            this.insertEntdecker("Bastien", "Courcol");
            this.insertEntdecker("Erik A.", "Petigura");
            this.insertEntdecker("Mario", "Damasso");
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim hinzuf\u00fcgen neuer Entdecker", sQLException);
        }
        try {
            this.reallocatePlanetsToNewDiscoverer("Hebrard", "G.", "Hebrard", "Guillaume");
            this.deleteDiscoverer("Hebrard", "G.");
            this.reallocatePlanetsToNewDiscoverer("Deleuil", "M.", "Deleuil", "Magali");
            this.deleteDiscoverer("Deleuil", "M.");
            this.reallocatePlanetsToNewDiscoverer("Charbonneau", "D.", "Charbonneau", "David");
            this.deleteDiscoverer("Charbonneau", "D.");
            this.reallocatePlanetsToNewDiscoverer("Torres", "G.", "Torres", "Guillermo");
            this.deleteDiscoverer("Torres", "G.");
            this.reallocatePlanetsToNewDiscoverer("Latham", "David", "Latham", "David W.");
            this.deleteDiscoverer("Latham", "David");
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim Bereinigen doppelter Entdecker", sQLException);
        }
        try {
            qEntdecker = QEntdecker.entdecker;
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qEntdecker).set((Path)qEntdecker.nachname, "Neuhaeuser")).where((Predicate)qEntdecker.nachname.eq("Neuheuser"))).execute();
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim Umbenennen von Entdeckernamen", sQLException);
        }
        try {
            this.datenbankverbinder.query("ALTER TABLE entdecker add column typ INTEGER");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.markAsSpaceTeleskope("Kepler Space Telescope");
            this.markAsSpaceTeleskope("CoRoT Telescope");
            this.markAsSpaceTeleskope("Hubble Space Telescope");
            this.markAsSpaceTeleskope("Voyager 2");
            this.markAsSpaceTeleskope("Voyager 1");
            qEntdecker = QEntdecker.entdecker;
            Entdecker entdecker = new Entdecker();
            entdecker.setNachname("Spitzer Space Telescope");
            entdecker.setTyp(EntdeckerTyp.SPACE_TELESCOPE.getType());
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
            this.markAsProject("SuperWASP Project");
            this.markAsProject("HATNet Project");
            this.markAsProject("HATSouth Survey");
            this.markAsProject("OGLE Project");
            this.markAsProject("XO Project");
            this.markAsProject("TrES Project");
            this.markAsProject("SWEEPS Project");
            this.markAsProject("MOA Project");
            this.markAsProject("AAPS Project");
            this.markAsProject("TERMS Project");
            this.markAsProject("Magellan Planet Search Program");
            this.markAsProject("Okayama Planet Search Program (OPSP)");
            this.markAsProject("N2K Consortium");
            this.saveNewProject("KELT Project");
            this.saveNewProject("Geneva Extrasolar Planet Search");
            this.saveNewProject("California and Carnegie Planet Search");
            this.saveNewProject("Gemini Planet Imager (GPI)");
            this.saveNewProject(EntdeckerProjekte.MCDONALD.getNameInDatabase());
            this.saveNewProject(EntdeckerProjekte.COROT_TEAM.getNameInDatabase());
            this.saveNewProject("Kepler Science Team");
            this.saveNewProject(EntdeckerProjekte.KMT.getNameInDatabase());
            this.reallocatePlanetsToNewProjectAndDeleteOldProject("HARPS Project", "Geneva Extrasolar Planet Search");
            this.reallocatePlanetsToNewProjectAndDeleteOldProject("SOPHIE Consortium", "Geneva Extrasolar Planet Search");
        }
        catch (SQLException sQLException) {
            LOGGER.error("Fehler beim Abspeichern von Exoplaneten-Projekten", sQLException);
        }
    }

    private void reallocatePlanetsToNewProjectAndDeleteOldProject(String string, String string2) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qZtentdecker).set((Path)qZtentdecker.entdeckerid, (Expression)((SQLQuery)SQLExpressions.select(qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(string2)))).where((Predicate)qZtentdecker.entdeckerid.eq((Expression)((SQLQuery)SQLExpressions.select(qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(string))))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qEntdecker).where((Predicate)qEntdecker.nachname.eq(string))).execute();
    }

    private void markAsProject(String string) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qEntdecker).set((Path)qEntdecker.typ, EntdeckerTyp.PROJECT.getType())).where((Predicate)qEntdecker.nachname.eq(string))).execute();
    }

    private void markAsSpaceTeleskope(String string) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qEntdecker).set((Path)qEntdecker.typ, EntdeckerTyp.SPACE_TELESCOPE.getType())).where((Predicate)qEntdecker.nachname.eq(string))).execute();
    }

    private void saveNewProject(String string) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        Entdecker entdecker = new Entdecker();
        entdecker.setNachname(string);
        entdecker.setTyp(EntdeckerTyp.PROJECT.getType());
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
    }

    private void deleteDiscoverer(String string, String string2) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qEntdecker).where((Predicate)qEntdecker.nachname.eq(string).and(qEntdecker.vorname.eq(string2)))).execute();
    }

    private void reallocatePlanetsToNewDiscoverer(String string, String string2, String string3, String string4) throws SQLException {
        QEntdecker qEntdecker = QEntdecker.entdecker;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(qZtentdecker).set((Path)qZtentdecker.entdeckerid, (Expression)((SQLQuery)SQLExpressions.select(qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(string3).and(qEntdecker.vorname.eq(string4))))).where((Predicate)qZtentdecker.entdeckerid.eq((Expression)((SQLQuery)SQLExpressions.select(qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(string).and(qEntdecker.vorname.eq(string2)))))).execute();
    }

    private void insertEntdecker(String string, String string2) throws SQLException {
        Entdecker entdecker = new Entdecker();
        entdecker.setNachname(string2);
        entdecker.setVorname(string);
        QEntdecker qEntdecker = QEntdecker.entdecker;
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(qEntdecker).populate(entdecker)).execute();
    }
}

