/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;

public final class Version91Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version91Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version91Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        try {
            this.datenbankverbinder.query("ALTER TABLE pht_transit_matches ADD COLUMN user_comment VARCHAR(256);");
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            LOGGER.info("spalte user_comment existiert schon: " + sQLSyntaxErrorException.getMessage());
        }
    }

    @Override
    public int updateToVersion() {
        return 91;
    }
}

