/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Version93Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version93Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version93Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("HIP 94235", List.of("TIC 464646604", "TOI-4399"));
        hashMap.put("HIP 13754", List.of("TIC 207141131", "TOI-179"));
        hashMap.put("HIP 17047", List.of("TIC 100990000", "TOI-411"));
        hashMap.put("HIP 6365", List.of("TIC 262530407", "TOI-177"));
        hashMap.put("HIP 20295", List.of("TIC 29781292", "TOI-282"));
        hashMap.put("HIP 15249", List.of("TIC 333657795", "TOI-4524"));
        for (Map.Entry entry : hashMap.entrySet()) {
            Daten daten;
            Daten daten2 = this.helper.readPlanetensucheObject((String)entry.getKey());
            if (daten2 == null || (daten = this.helper.readPlanetensucheObject((String)((List)entry.getValue()).get(0))) == null || daten2.getId().intValue() == daten.getId().intValue()) continue;
            this.helper.moveChildObjectsToNewParent(daten.getId(), daten2.getId());
            this.helper.deletePlanetensucheObject(daten.getId());
            this.helper.addNamen((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            this.helper.addNamen((String)entry.getKey(), (String)((List)entry.getValue()).get(1));
        }
    }

    @Override
    public int updateToVersion() {
        return 93;
    }
}

