/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version95Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version95Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version95Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QKategorie qKategorie = QKategorie.kategorie;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).fetch();
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list).and(qDaten.entdeckungbestaetigt.isFalse()).and(qDaten.durchmesser.eq(0.0)).and(qDaten.masse.eq(0.0)).and(qDaten.umlaufszeit.eq(0.0)))).fetch();
        for (Integer n : list2) {
            this.helper.deletePlanetensucheObject(n);
        }
    }

    @Override
    public int updateToVersion() {
        return 95;
    }
}

