/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Version96Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version96Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version96Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        Object object;
        Map.Entry entry2;
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QKategorie qKategorie = QKategorie.kategorie;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).fetch();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("KOI-12 c", List.of("KIC 5812701 c", "Kepler-448 c"));
        hashMap.put("KOI-1783 b", List.of("Kepler-1662 b", "KOI-1783.01", "KIC 10005758 b"));
        hashMap.put("KOI-1783 c", List.of("Kepler-1662 c", "KOI-1783.02", "KIC 10005758 c"));
        hashMap.put("KOI-142 d", List.of("Kepler-88 d", "KIC 5446285 d"));
        hashMap.put("EPIC 201757695 b", List.of("K2-328 b", "EPIC 201757695.02"));
        hashMap.put("EPIC 201170410 b", List.of("K2-327 b", "EPIC 201170410.02"));
        for (Map.Entry entry2 : hashMap.entrySet()) {
            object = (String)entry2.getKey();
            Daten daten = this.helper.readPlanetensucheObject((String)object);
            if (daten == null) continue;
            List list2 = (List)entry2.getValue();
            for (String string : list2) {
                Daten daten2 = this.helper.readPlanetensucheObject(string);
                if (daten2 == null) {
                    this.helper.addNamen((String)object, string);
                    continue;
                }
                if (daten2.getId().intValue() == daten.getId().intValue()) continue;
                this.helper.deletePlanetensucheObject(daten2.getId());
                this.helper.addNamen((String)object, string);
            }
        }
        List list3 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in(list).and(qDaten.entdeckungbestaetigt.isFalse()).and(qDaten.durchmesser.eq(0.0)).and(qDaten.masse.eq(0.0)).and(qDaten.umlaufszeit.eq(0.0)))).fetch();
        entry2 = list3.iterator();
        while (entry2.hasNext()) {
            object = (Integer)entry2.next();
            this.helper.deletePlanetensucheObject((Integer)object);
        }
    }

    @Override
    public int updateToVersion() {
        return 96;
    }
}

