/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version97Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version97Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version97Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        Daten daten = this.helper.readPlanetensucheObject("LP 358-499");
        Daten daten2 = this.helper.readPlanetensucheObject("K2-133");
        if (daten != null) {
            if (daten2 == null) {
                this.helper.addNamen("LP 358-499", "K2-133");
                this.helper.addNamen("LP 358-499", "EPIC 247887989");
                this.helper.addNamen("LP 358-499", "TIC 150096001");
                this.helper.addNamen("LP 358-499", "Gaia DR2 148080473682357376");
            } else if (daten.getId().intValue() != daten2.getId().intValue()) {
                this.helper.moveChildObjectsToNewParent(daten.getId(), daten2.getId());
                this.helper.deletePlanetensucheObject(daten.getId());
                this.helper.addNamen("K2-133", "LP 358-499");
                this.helper.addNamen("K2-133", "ASCC 659586");
                this.helper.addNamen("K2-133", "2MASS J04403562+2500361");
                this.helper.addNamen("K2-133", "NLTT 13719");
            }
        } else if (daten2 != null) {
            this.helper.addNamen("K2-133", "LP 358-499");
            this.helper.addNamen("K2-133", "ASCC 659586");
            this.helper.addNamen("K2-133", "2MASS J04403562+2500361");
            this.helper.addNamen("K2-133", "NLTT 13719");
        }
    }

    @Override
    public int updateToVersion() {
        return 97;
    }
}

