/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.impl.migration.MigrationHelper;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;

public final class Version99Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version99Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final MigrationHelper helper;

    public Version99Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.helper = new MigrationHelper(iDatenbankverbinder);
    }

    @Override
    public void update() throws SQLException {
        LOGGER.debug("starting DB migration to Version " + this.updateToVersion());
        Daten daten = this.helper.readPlanetensucheObject("HD 109833");
        Daten daten2 = this.helper.readPlanetensucheObject("TOI-1097");
        if (daten != null && daten2 == null) {
            this.helper.addNamen("HD 109833", "TOI-1097");
            this.helper.addNamen("HD 109833", "TIC 360630575");
        } else if (daten != null && daten2 != null && daten.getId().intValue() != daten2.getId().intValue()) {
            this.helper.moveChildObjectsToNewParent(daten2.getId(), daten.getId());
            this.helper.deletePlanetensucheObject(daten2.getId());
            this.helper.addNamen("HD 109833", "TOI-1097");
            this.helper.addNamen("HD 109833", "TIC 360630575");
        }
        Daten daten3 = this.helper.readPlanetensucheObject("TOI-2180 b");
        Daten daten4 = this.helper.readPlanetensucheObject("TOI-2180.01");
        if (daten3 != null && daten4 != null) {
            this.helper.deletePlanetensucheObject(daten4.getId());
            this.helper.addNamen("TOI-2180 b", "TOI-2180.01");
            this.helper.addNamen("TOI-2180 b", "TIC 298663873.01");
        }
        daten3 = this.helper.readPlanetensucheObject("Kepler-429 b");
        daten4 = this.helper.readPlanetensucheObject("Kepler-429 c");
        if (daten3 != null && daten4 != null && daten3.getId().intValue() == daten4.getId().intValue()) {
            this.helper.deletePlanetensucheObject(daten3.getId());
        }
    }

    @Override
    public int updateToVersion() {
        return 99;
    }
}

