/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.migration;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.migration.DatabaseUpdater;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public final class Version9Migrator
implements DatabaseUpdater {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(Version9Migrator.class);
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public Version9Migrator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public int updateToVersion() {
        return 9;
    }

    @Override
    public void update() {
        try {
            boolean bl = true;
            QEntdecker qEntdecker = QEntdecker.entdecker;
            QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qEntdecker.nachname).from((Expression<?>)qEntdecker)).groupBy((Expression<?>[])new Expression[]{qEntdecker.nachname, qEntdecker.vorname})).having(qEntdecker.nachname.count().gt(1).and(qEntdecker.vorname.count().gt(1)))).fetch();
            LOGGER.debug("entdecker doppelt?");
            for (String string : list) {
                LOGGER.debug("doppelter entdecker " + string + " gefunden");
                List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qZtentdecker.id).from((Expression<?>)qZtentdecker)).where(qZtentdecker.entdeckerid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qEntdecker.id).from((Expression<?>)qEntdecker)).where(qEntdecker.nachname.eq(string))))).fetch();
                if (list2.isEmpty()) {
                    ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qEntdecker).where((Predicate)qEntdecker.nachname.eq(string))).execute();
                    continue;
                }
                bl = false;
                LOGGER.debug("entdecker " + string + " kann nicht gel\u00f6scht werden, da " + list2.size() + " objekte darauf verweisen!");
            }
            if (bl) {
                this.datenbankverbinder.query("ALTER TABLE ENTDECKER ADD CONSTRAINT chk_nameunique UNIQUE (nachname, vorname);");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            LOGGER.error("Fehler beim Hinzuf\u00fcgen eines constraints", sQLException);
        }
    }
}

