/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IBilderRepository;
import de.planetensuche.datenbankkern.querydsl5.Bilder;
import de.planetensuche.datenbankkern.querydsl5.QBilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class BilderRepository
implements IBilderRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QBilder qBilder = QBilder.bilder;

    @Inject
    public BilderRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public List<String> getBilder() throws SQLException {
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qBilder).from((Expression<?>)this.qBilder)).fetch();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Bilder bilder : list) {
            arrayList.add(bilder.getBild());
        }
        return arrayList;
    }

    @Override
    public Integer getId(String string) throws SQLException {
        try {
            Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qBilder.id).from((Expression<?>)this.qBilder)).where(this.qBilder.bild.eq(string))).fetchFirst();
            return n;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new NonUniqueResultException("Es wurden mehrere ids f\u00fcr '" + string + "' gefunden!");
        }
    }

    @Override
    public Bilder read(int n) throws SQLException {
        Bilder bilder = (Bilder)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qBilder).from((Expression<?>)this.qBilder)).where(this.qBilder.id.eq(n))).fetchFirst();
        return bilder;
    }

    @Override
    public Integer create(Bilder bilder) throws SQLException {
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qBilder).populate(bilder)).executeWithKey(this.qBilder.id);
        return n;
    }

    @Override
    public void update(Bilder bilder) throws SQLException {
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qBilder).where((Predicate)this.qBilder.id.eq(bilder.getId()))).populate(bilder)).execute();
    }

    @Override
    public void delete(int n) throws SQLException {
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qBilder).where((Predicate)this.qBilder.id.eq(n))).execute();
    }
}

