/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datenbankkern.api.repos.IDatenPojoIdDeepSkyMapper;
import de.planetensuche.datenbankkern.api.repos.IGalaxienartenRepository;
import de.planetensuche.datenbankkern.api.repos.IGalaxienformenRepository;
import de.planetensuche.datenbankkern.api.repos.INebelformenRepository;
import de.planetensuche.datenbankkern.api.repos.ISternhaufenformenRepository;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Galaxienart;
import de.planetensuche.datenbankkern.querydsl5.Galaxienform;
import de.planetensuche.datenbankkern.querydsl5.Nebelform;
import de.planetensuche.datenbankkern.querydsl5.Sternhaufenform;
import java.sql.SQLException;

public final class DatenPojoIdDeepSkyMapper
implements IDatenPojoIdDeepSkyMapper {
    private final ISternhaufenformenRepository sternhaufenformenRepository;
    private final INebelformenRepository nebelformenRepository;
    private final IGalaxienformenRepository galaxienformenRepository;
    private final IGalaxienartenRepository galaxienartenRepository;

    @Inject
    public DatenPojoIdDeepSkyMapper(ISternhaufenformenRepository iSternhaufenformenRepository, INebelformenRepository iNebelformenRepository, IGalaxienformenRepository iGalaxienformenRepository, IGalaxienartenRepository iGalaxienartenRepository) {
        this.sternhaufenformenRepository = iSternhaufenformenRepository;
        this.nebelformenRepository = iNebelformenRepository;
        this.galaxienformenRepository = iGalaxienformenRepository;
        this.galaxienartenRepository = iGalaxienartenRepository;
    }

    @Override
    public void mapIds(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer, Daten daten, int n) throws SQLException {
        Integer n2;
        if (!iPlanetensucheObjektPruefer.isSternhaufenformUnbekannt()) {
            n2 = this.sternhaufenformenRepository.getId(iPlanetensucheObjektPruefer.getSternhaufenform(), n);
            daten.setSternhaufenform(n2);
        }
        if (!iPlanetensucheObjektPruefer.isNebelformUnbekannt()) {
            n2 = this.nebelformenRepository.getId(iPlanetensucheObjektPruefer.getNebelform());
            daten.setNebelform(n2);
        }
        if (!iPlanetensucheObjektPruefer.isGalaxienformUnbekannt()) {
            n2 = this.galaxienformenRepository.getId(iPlanetensucheObjektPruefer.getGalaxienform());
            daten.setGalaxienform(n2);
        }
        if (!iPlanetensucheObjektPruefer.isGalaxienartUnbekannt()) {
            n2 = this.galaxienartenRepository.getId(iPlanetensucheObjektPruefer.getGalaxienart());
            daten.setGalaxienart(n2);
        }
    }

    @Override
    public void mapIds(Daten daten, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        Object object;
        if (daten.getSternhaufenform() != null) {
            object = this.sternhaufenformenRepository.read(daten.getSternhaufenform());
            iPlanetensucheObjekt.setSternhaufenform(((Sternhaufenform)object).getForm());
        }
        if (daten.getNebelform() != null) {
            object = this.nebelformenRepository.read(daten.getNebelform());
            iPlanetensucheObjekt.setNebelform(((Nebelform)object).getForm());
        }
        if (daten.getGalaxienform() != null) {
            object = this.galaxienformenRepository.read(daten.getGalaxienform());
            iPlanetensucheObjekt.setGalaxienform(((Galaxienform)object).getForm());
        }
        if (daten.getGalaxienart() != null) {
            object = this.galaxienartenRepository.read(daten.getGalaxienart());
            iPlanetensucheObjekt.setGalaxienart(((Galaxienart)object).getArt());
        }
    }
}

