/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.repos.IDatenPojoIdDeepSkyMapper;
import de.planetensuche.datenbankkern.api.repos.IDatenPojoIdMapper;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.ILeuchtkraftklassenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.datenbankkern.api.repos.ISpektraltypenRepository;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdeckungsmethode;
import de.planetensuche.datenbankkern.querydsl5.Kategorie;
import de.planetensuche.datenbankkern.querydsl5.Lumin;
import de.planetensuche.datenbankkern.querydsl5.Objekttypen;
import de.planetensuche.datenbankkern.querydsl5.Spektraltyp;
import de.planetensuche.datenbankkern.querydsl5.Spektraltyp2;
import java.sql.SQLException;

public final class DatenPojoIdMapper
implements IDatenPojoIdMapper {
    private final IObjekttypenRepository objekttypenRepository;
    private final IKategorienRepository kategorienRepository;
    private final ISpektraltypenRepository spektraltypenRepository;
    private final ILeuchtkraftklassenRepository leuchtkraftklassenRepository;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IDatenPojoIdDeepSkyMapper deepSkyMapper;

    @Inject
    public DatenPojoIdMapper(IObjekttypenRepository iObjekttypenRepository, IKategorienRepository iKategorienRepository, ISpektraltypenRepository iSpektraltypenRepository, ILeuchtkraftklassenRepository iLeuchtkraftklassenRepository, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IDatenPojoIdDeepSkyMapper iDatenPojoIdDeepSkyMapper) {
        this.objekttypenRepository = iObjekttypenRepository;
        this.kategorienRepository = iKategorienRepository;
        this.spektraltypenRepository = iSpektraltypenRepository;
        this.leuchtkraftklassenRepository = iLeuchtkraftklassenRepository;
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.deepSkyMapper = iDatenPojoIdDeepSkyMapper;
    }

    @Override
    public void mapIds(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer, Daten daten) throws SQLException {
        Integer n = this.kategorienRepository.getId(iPlanetensucheObjektPruefer.getKategorie());
        Objekttypen objekttypen = this.objekttypenRepository.read(iPlanetensucheObjektPruefer.getObjekttyp());
        daten.setObjektid(objekttypen.getId());
        Integer n2 = this.spektraltypenRepository.getId(n, iPlanetensucheObjektPruefer.getSpektralklasse());
        daten.setSpektralklasse(n2);
        Integer n3 = this.spektraltypenRepository.getId(n, iPlanetensucheObjektPruefer.getSpektralklasse2());
        daten.setSpektralklasse2(n3);
        Integer n4 = this.leuchtkraftklassenRepository.getId(iPlanetensucheObjektPruefer.getLeuchtkraftklasse());
        daten.setLumin(n4);
        if (!iPlanetensucheObjektPruefer.isEntdeckungsmethodeUnbekannt()) {
            Integer n5 = this.entdeckungsmethodenRepository.getId(iPlanetensucheObjektPruefer.getEntdeckungsmethode());
            daten.setEntdeckungsmethode(n5);
        }
        this.deepSkyMapper.mapIds(iPlanetensucheObjektPruefer, daten, objekttypen.getId());
    }

    @Override
    public void mapIds(Daten daten, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        Object object;
        Objekttypen objekttypen = this.objekttypenRepository.read(daten.getObjektid());
        iPlanetensucheObjekt.setObjekttyp(objekttypen.getTyp());
        Kategorie kategorie = this.kategorienRepository.read(objekttypen.getKategorieid());
        iPlanetensucheObjekt.setCategory(ObjektKategorie.parse(kategorie.getName()));
        if (daten.getSpektralklasse() != null) {
            object = this.spektraltypenRepository.read(daten.getSpektralklasse());
            iPlanetensucheObjekt.setSpektralklasse(((Spektraltyp)object).getTyp());
            if (daten.getSpektralklasse2() != null) {
                Spektraltyp2 spektraltyp2 = this.spektraltypenRepository.read2(daten.getSpektralklasse2());
                iPlanetensucheObjekt.setSpektralklasse2(spektraltyp2.getTyp());
            }
        }
        if (daten.getLumin() != null) {
            object = this.leuchtkraftklassenRepository.read(daten.getLumin());
            iPlanetensucheObjekt.setLeuchtkraftklasse(((Lumin)object).getTyp());
        }
        if (daten.getEntdeckungsmethode() != null) {
            object = this.entdeckungsmethodenRepository.read(daten.getEntdeckungsmethode());
            iPlanetensucheObjekt.setEntdeckungsmethode(((Entdeckungsmethode)object).getMethode());
        }
        this.deepSkyMapper.mapIds(daten, iPlanetensucheObjekt);
    }
}

