/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class EntdeckerRepository
implements IEntdeckerRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QEntdecker qEntdecker = QEntdecker.entdecker;
    private final IPlanetenRepository planetenRepo;

    @Inject
    public EntdeckerRepository(IDatenbankverbinder iDatenbankverbinder, IPlanetenRepository iPlanetenRepository) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.planetenRepo = iPlanetenRepository;
    }

    @Override
    public Integer getId(String string, String string2) throws SQLException {
        try {
            if (string2 == null || string2.isEmpty() || "null".equalsIgnoreCase(string2)) {
                Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker.id).from((Expression<?>)this.qEntdecker)).where(this.qEntdecker.nachname.eq(string))).fetchFirst();
                return n;
            }
            Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker.id).from((Expression<?>)this.qEntdecker)).where(this.qEntdecker.nachname.eq(string).and(this.qEntdecker.vorname.eq(string2)))).fetchFirst();
            return n;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new SQLException("Aufruf mit Nachname '" + string + "' und Vorname '" + string2 + "' nicht eindeutig!", nonUniqueResultException);
        }
    }

    @Override
    public Entdecker read(int n) throws SQLException {
        Entdecker entdecker = (Entdecker)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).where(this.qEntdecker.id.eq(n))).fetchFirst();
        return entdecker;
    }

    @Override
    public List<Entdecker> getEntdecker() throws SQLException {
        List<Entdecker> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).orderBy((OrderSpecifier<?>)this.qEntdecker.nachname.asc())).fetch();
        return list;
    }

    @Override
    public boolean save(String string, String string2, String string3, String string4, EntdeckerTyp entdeckerTyp) throws SQLException {
        Integer n;
        if (string3.trim().length() < 2) {
            throw new IllegalArgumentException("Entdeckername '" + string3.trim() + "' zu kurz zum hinzufuegen!");
        }
        Entdecker entdecker = new Entdecker();
        entdecker.setFachgebiet(string4);
        entdecker.setNachname(string3);
        if (!"null".equals(string) && !"".equals(string)) {
            entdecker.setVorname(string);
        }
        if (entdeckerTyp != null) {
            entdecker.setTyp(entdeckerTyp.getType());
        }
        if ((n = this.getId(string3, string2)) != null) {
            entdecker.setId(n);
            SQLUpdateClause sQLUpdateClause = this.datenbankverbinder.getNewSqlUpdateClause(this.qEntdecker);
            ((SQLUpdateClause)sQLUpdateClause.populate(entdecker)).where((Predicate)this.qEntdecker.id.eq(n));
            long l = sQLUpdateClause.execute();
            return l == 1L;
        }
        SQLInsertClause sQLInsertClause = this.datenbankverbinder.getNewSqlInsertClause(this.qEntdecker);
        sQLInsertClause.populate(entdecker);
        return sQLInsertClause.execute() == 1L;
    }

    @Override
    public boolean delete(String string, String string2) throws SQLException {
        List<Integer> list = this.getObjektidsFuerEntdecker(string, string2);
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(list.size());
            for (Integer n : list) {
                stringBuilder.append(n).append(", ");
            }
            throw new IllegalArgumentException("Der Entdecker '" + string + "' kann nicht geloescht werden, weil noch " + list.size() + " Objekte (" + stringBuilder.toString() + ") darauf verweisen!");
        }
        SQLDeleteClause sQLDeleteClause = this.datenbankverbinder.getNewSqlDeleteClause(this.qEntdecker);
        return (sQLDeleteClause = (SQLDeleteClause)sQLDeleteClause.where((Predicate)this.qEntdecker.vorname.eq(string2).and(this.qEntdecker.nachname.eq(string)))).execute() == 1L;
    }

    @Override
    public List<Integer> getObjektidsFuerEntdecker(String string, String string2) throws SQLException {
        Integer n = this.getId(string, string2);
        if (n == null) {
            throw new IllegalArgumentException("Entdecker '" + string2 + " " + string + "' existiert nicht!");
        }
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        List<Integer> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qZtentdecker.datenid).from((Expression<?>)qZtentdecker)).where(qZtentdecker.entdeckerid.eq(n))).fetch();
        return list;
    }

    @Override
    public List<Entdecker> findByLastname(String string) throws SQLException {
        List<Entdecker> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).where(this.qEntdecker.nachname.eq(string))).fetch();
        return list;
    }

    @Override
    public List<Entdecker> findAllDiscovererPersons() {
        List<Entdecker> list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).where(this.qEntdecker.typ.eq(EntdeckerTyp.PERSON.getType()).or(this.qEntdecker.typ.isNull()))).orderBy((OrderSpecifier<?>)this.qEntdecker.nachname.asc())).fetch();
        return list;
    }

    @Override
    public List<Entdecker> findAllExoplanetDiscovererPersons() {
        QDaten qDaten = QDaten.daten;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        List<Entdecker> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).join((EntityPath)qZtentdecker)).on((Predicate)this.qEntdecker.id.eq(qZtentdecker.entdeckerid))).join((EntityPath)qDaten)).on((Predicate)qDaten.id.eq(qZtentdecker.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.planetenRepo.getObjekttypenidsPlaneten()).and(this.qEntdecker.typ.eq(EntdeckerTyp.PERSON.getType()).or(this.qEntdecker.typ.isNull())))).orderBy((OrderSpecifier<?>)this.qEntdecker.nachname.asc())).fetch();
        return list;
    }

    @Override
    public List<Entdecker> findAllDiscovererTeams() {
        List<Entdecker> list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).where(this.qEntdecker.typ.eq(EntdeckerTyp.PROJECT.getType()))).orderBy((OrderSpecifier<?>)this.qEntdecker.nachname.asc())).fetch();
        return list;
    }

    @Override
    public List<Entdecker> findAllSpaceTelescopes() {
        List<Entdecker> list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdecker).from((Expression<?>)this.qEntdecker)).where(this.qEntdecker.typ.eq(EntdeckerTyp.SPACE_TELESCOPE.getType()))).orderBy((OrderSpecifier<?>)this.qEntdecker.nachname.asc())).fetch();
        return list;
    }
}

