/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.querydsl5.Entdeckungsmethode;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdeckungsmethode;
import java.sql.SQLException;
import java.util.List;

public final class EntdeckungsmethodenRepository
implements IEntdeckungsmethodenRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QEntdeckungsmethode qEntdeckungsmethode = QEntdeckungsmethode.entdeckungsmethode;

    @Inject
    public EntdeckungsmethodenRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public Integer getId(String string) throws SQLException {
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdeckungsmethode.id).from((Expression<?>)this.qEntdeckungsmethode)).where(this.qEntdeckungsmethode.methode.eq(string))).fetchFirst();
        return n;
    }

    @Override
    public Entdeckungsmethode read(int n) throws SQLException {
        Entdeckungsmethode entdeckungsmethode = (Entdeckungsmethode)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdeckungsmethode).from((Expression<?>)this.qEntdeckungsmethode)).where(this.qEntdeckungsmethode.id.eq(n))).fetchFirst();
        return entdeckungsmethode;
    }

    @Override
    public List<String> getEntdeckungsmethoden() throws SQLException {
        List<String> list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qEntdeckungsmethode.methode).from((Expression<?>)this.qEntdeckungsmethode)).fetch();
        return list;
    }

    @Override
    public boolean delete(String string) throws SQLException {
        if (this.getId(string) == null) {
            throw new IllegalArgumentException("Die Entdeckungsmethode '" + string + "' existiert nicht und kann darum nicht geloescht werden!");
        }
        List<Integer> list = this.getObjekteFuerEntdeckungsmethode(string);
        if (!list.isEmpty()) {
            throw new IllegalArgumentException("Die Entdeckungsmethode '" + string + "' kann nicht geloescht werden, weil noch " + list.size() + " Objekte darauf verweisen!");
        }
        SQLDeleteClause sQLDeleteClause = (SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qEntdeckungsmethode).where((Predicate)this.qEntdeckungsmethode.methode.eq(string));
        return sQLDeleteClause.execute() == 1L;
    }

    @Override
    public boolean save(String string) throws SQLException {
        if (this.getId(string) != null) {
            return true;
        }
        Entdeckungsmethode entdeckungsmethode = new Entdeckungsmethode();
        entdeckungsmethode.setMethode(string);
        SQLInsertClause sQLInsertClause = (SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qEntdeckungsmethode).populate(entdeckungsmethode);
        return sQLInsertClause.execute() == 1L;
    }

    @Override
    public List<Integer> getObjekteFuerEntdeckungsmethode(String string) throws SQLException {
        Integer n = this.getId(string);
        if (n == null) {
            throw new IllegalArgumentException("Entdeckungsmethode '" + string + "' existiert nicht!");
        }
        QDaten qDaten = QDaten.daten;
        List<Integer> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.entdeckungsmethode.eq(n))).fetch();
        return list;
    }
}

