/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.GaiaStarsEntity;
import de.planetensuche.datenbankkern.api.repos.IGaiaStarsRepository;
import de.planetensuche.datenbankkern.querydsl5.GaiaStars;
import de.planetensuche.datenbankkern.querydsl5.QGaiaStars;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GaiaStarsRepository
implements IGaiaStarsRepository {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final QGaiaStars qGaiaStars = QGaiaStars.gaiaStars;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public GaiaStarsRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void save(GaiaStarsEntity gaiaStarsEntity) throws SQLException {
        if (gaiaStarsEntity.getDatenid() == null) {
            throw new IllegalArgumentException("datenId is null");
        }
        if (gaiaStarsEntity.getId() == null) {
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qGaiaStars).populate(gaiaStarsEntity)).execute();
        } else {
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qGaiaStars).populate(gaiaStarsEntity)).where((Predicate)this.qGaiaStars.id.eq(gaiaStarsEntity.getId()))).execute();
        }
    }

    @Override
    public GaiaStarsEntity readByDatenId(int n) {
        GaiaStars gaiaStars = (GaiaStars)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qGaiaStars).where(this.qGaiaStars.datenid.eq(n))).fetchOne();
        if (gaiaStars == null) {
            return null;
        }
        return new GaiaStarsEntity(gaiaStars);
    }

    @Override
    public List<GaiaStarsEntity> findByDatenIds(List<Integer> list) {
        ArrayList<GaiaStarsEntity> arrayList = new ArrayList<GaiaStarsEntity>();
        List list2 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qGaiaStars).where(this.qGaiaStars.datenid.in((Collection<Integer>)list))).fetch();
        for (GaiaStars gaiaStars : list2) {
            arrayList.add(new GaiaStarsEntity(gaiaStars));
        }
        return arrayList;
    }

    @Override
    public void save(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer) throws SQLException {
        if (iPlanetensucheObjektPruefer.isGaiaAstroExNoiseSigUnbekannt() && iPlanetensucheObjektPruefer.isGaiaNonSingleUnbekannt() && iPlanetensucheObjektPruefer.isGaiaRuweUnbekannt() && iPlanetensucheObjektPruefer.isGaiaRvErrorUnbekannt()) {
            return;
        }
        GaiaStarsEntity gaiaStarsEntity = this.readByDatenId(iPlanetensucheObjektPruefer.getDatenid());
        if (gaiaStarsEntity == null) {
            gaiaStarsEntity = new GaiaStarsEntity();
            gaiaStarsEntity.setDatenid(iPlanetensucheObjektPruefer.getDatenid());
        }
        if (!iPlanetensucheObjektPruefer.isGaiaAstroExNoiseSigUnbekannt()) {
            gaiaStarsEntity.setAstroExNoiseSig(iPlanetensucheObjektPruefer.getGaiaAstroExNoiseSig());
        }
        if (!iPlanetensucheObjektPruefer.isGaiaNonSingleUnbekannt()) {
            gaiaStarsEntity.setNonSingle(iPlanetensucheObjektPruefer.getGaiaNonSingle());
        }
        if (!iPlanetensucheObjektPruefer.isGaiaRuweUnbekannt()) {
            gaiaStarsEntity.setRuwe(iPlanetensucheObjektPruefer.getGaiaRuwe());
        }
        if (!iPlanetensucheObjektPruefer.isGaiaRvErrorUnbekannt()) {
            gaiaStarsEntity.setRvError(iPlanetensucheObjektPruefer.getGaiaRvError());
        }
        this.save(gaiaStarsEntity);
    }
}

