/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.helfer.HabitateZoneRechner;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.querydsl5.HabitableZone;
import de.planetensuche.datenbankkern.querydsl5.QHabitableZone;
import java.sql.SQLException;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class HabitableZoneRepository
implements IHabitableZoneRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QHabitableZone qHabitableZone = QHabitableZone.habitableZone;

    @Inject
    public HabitableZoneRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public void calculateAndSave(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        if (iPlanetensucheObjekt.getDatenid() == null) {
            throw new IllegalArgumentException("Planetensuche Objekt noch nicht gespeichert");
        }
        if (!ObjektKategorie.STERNE.getKategorienName().equals(iPlanetensucheObjekt.getKategorie())) {
            return;
        }
        HabitateZoneRechner habitateZoneRechner = new HabitateZoneRechner();
        if (habitateZoneRechner.berechne(iPlanetensucheObjekt)) {
            boolean bl = false;
            HabitableZone habitableZone = (HabitableZone)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qHabitableZone).where(this.qHabitableZone.datenid.eq(iPlanetensucheObjekt.getDatenid()))).fetchOne();
            if (habitableZone == null) {
                bl = true;
                habitableZone = new HabitableZone();
                habitableZone.setDatenid(iPlanetensucheObjekt.getDatenid());
            }
            habitableZone.setInnerHz(habitateZoneRechner.getInnereHZ());
            habitableZone.setOuterHz(habitateZoneRechner.getAussereHZ());
            if (bl) {
                ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qHabitableZone).populate(habitableZone)).execute();
            } else {
                ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qHabitableZone).populate(habitableZone)).where((Predicate)this.qHabitableZone.datenid.eq(habitableZone.getDatenid()))).execute();
            }
        }
    }

    @Override
    public Optional<Pair<Double, Double>> getInnerAndOuterHZ(int n) {
        HabitableZone habitableZone = (HabitableZone)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qHabitableZone).where(this.qHabitableZone.datenid.eq(n))).fetchOne();
        if (habitableZone == null) {
            return Optional.empty();
        }
        return Optional.of(Pair.of(habitableZone.getInnerHz(), habitableZone.getOuterHz()));
    }

    @Override
    public void delete(int n) throws SQLException {
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qHabitableZone).where((Predicate)this.qHabitableZone.datenid.eq(n))).execute();
    }
}

