/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.querydsl5.Kategorie;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import java.sql.SQLException;
import java.util.List;

public final class KategorienRepository
implements IKategorienRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QKategorie qKategorie = QKategorie.kategorie;

    @Inject
    public KategorienRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public Integer getId(String string) throws SQLException {
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(string))).fetchFirst();
        return n;
    }

    @Override
    public Kategorie read(int n) throws SQLException {
        Kategorie kategorie = (Kategorie)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qKategorie).from((Expression<?>)this.qKategorie)).where(this.qKategorie.id.eq(n))).fetchFirst();
        return kategorie;
    }

    @Override
    public String getKategorieFuerObjekt(int n) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QDaten qDaten = QDaten.daten;
        String string = (String)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qKategorie.name).from((Expression<?>)this.qKategorie)).where(this.qKategorie.id.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.kategorieid).from((Expression<?>)qObjekttypen)).where(qObjekttypen.id.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.objektid).from((Expression<?>)qDaten)).where(qDaten.id.eq(n))))))).fetchFirst();
        return string;
    }

    @Override
    public String getKategorieFuerObjekt(String string) throws SQLException {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        String string2 = (String)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qKategorie.name).from((Expression<?>)this.qKategorie)).where(this.qKategorie.id.eq((Expression)((SQLQuery)SQLExpressions.select(qObjekttypen.kategorieid).from((Expression<?>)qObjekttypen)).where(qObjekttypen.id.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.objektid).from((Expression<?>)qDaten)).where(qDaten.id.eq((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq(string))))))))).fetchFirst();
        return string2;
    }

    @Override
    public List<String> getKategorien() throws SQLException {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qKategorie.name).from((Expression<?>)this.qKategorie)).orderBy((OrderSpecifier<?>)this.qKategorie.name.asc())).fetch();
    }

    @Override
    public List<Integer> getDatenidsFuerKategorie(String string) throws SQLException {
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        List<Integer> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(string))))))).fetch();
        return list;
    }

    @Override
    public int getAnzahl(String string) throws SQLException {
        if (Check.isEmpty(string)) {
            throw new IllegalArgumentException("kategorie ist null");
        }
        QDaten qDaten = QDaten.daten;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        SQLQuery sQLQuery = (SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id.count()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(string))))));
        long l = sQLQuery.fetchCount();
        return (int)l;
    }

    @Override
    public int getAnzahlAllerKategorien() throws SQLException {
        QDaten qDaten = QDaten.daten;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten).from((Expression<?>)qDaten)).fetchCount();
        return (int)l;
    }
}

