/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.INotizenRepository;
import de.planetensuche.datenbankkern.querydsl5.Notizen;
import de.planetensuche.datenbankkern.querydsl5.QNotizen;
import java.sql.SQLException;

public final class NotizenRepository
implements INotizenRepository {
    private static final QNotizen Q_NOTIZEN = QNotizen.notizen;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public NotizenRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public String getByDatenid(Integer n) throws SQLException {
        return (String)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)NotizenRepository.Q_NOTIZEN.notiz).from((Expression<?>)Q_NOTIZEN)).where(NotizenRepository.Q_NOTIZEN.datenid.eq(n))).fetchFirst();
    }

    @Override
    public void save(Integer n, String string) throws SQLException {
        if (n == null) {
            throw new IllegalArgumentException("datenId is null");
        }
        Notizen notizen = (Notizen)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)Q_NOTIZEN).where(NotizenRepository.Q_NOTIZEN.datenid.eq(n))).fetchFirst();
        if (notizen == null && Check.isEmpty(string)) {
            return;
        }
        if ((notizen == null || Check.isEmpty(notizen.getNotiz())) && Check.isEmpty(string)) {
            return;
        }
        if (notizen == null) {
            notizen = new Notizen();
            notizen.setDatenid(n);
            notizen.setNotiz(string);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(Q_NOTIZEN).populate(notizen)).execute();
        } else if (!notizen.getNotiz().equals(string)) {
            String string2 = string;
            if (string == null) {
                string2 = "";
            }
            string2 = string2.trim();
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(Q_NOTIZEN).set((Path)NotizenRepository.Q_NOTIZEN.notiz, string2)).where((Predicate)NotizenRepository.Q_NOTIZEN.id.eq(notizen.getId()))).execute();
        }
    }

    @Override
    public int countAll() throws SQLException {
        return (int)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)Q_NOTIZEN).fetchCount();
    }
}

