/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IObjektalterRepository;
import de.planetensuche.datenbankkern.querydsl5.Objektalter;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import java.sql.SQLException;

public final class ObjektalterRepository
implements IObjektalterRepository {
    private final QObjektalter qObjektalter = QObjektalter.objektalter;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public ObjektalterRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public Integer getId(Integer n) throws SQLException {
        if (n == null) {
            throw new IllegalArgumentException("datenid ist null!");
        }
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qObjektalter.id).from((Expression<?>)this.qObjektalter)).where(this.qObjektalter.datenid.eq(n))).fetchFirst();
        return n2;
    }

    @Override
    public void save(Integer n, Double d) throws SQLException {
        Objektalter objektalter = this.read(n);
        if (objektalter == null) {
            if (d == 0.0) {
                return;
            }
            Objektalter objektalter2 = new Objektalter();
            objektalter2.setDatenid(n);
            objektalter2.setAlter(d);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qObjektalter).populate(objektalter2)).execute();
        } else if (d == null || d == 0.0) {
            this.delete(objektalter.getId());
        } else {
            objektalter.setAlter(d);
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qObjektalter).where((Predicate)this.qObjektalter.id.eq(objektalter.getId()))).populate(objektalter)).execute();
        }
    }

    @Override
    public Objektalter read(Integer n) throws SQLException {
        if (n == null) {
            throw new IllegalArgumentException("datenid ist null!");
        }
        Objektalter objektalter = (Objektalter)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qObjektalter).from((Expression<?>)this.qObjektalter)).where(this.qObjektalter.datenid.eq(n))).fetchFirst();
        return objektalter;
    }

    @Override
    public void delete(Integer n) throws SQLException {
        if (n == null) {
            throw new IllegalArgumentException("id ist null!");
        }
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qObjektalter).where((Predicate)this.qObjektalter.id.eq(n))).execute();
    }
}

