/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.QueryException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.core.Check;
import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.exceptions.PlanetensucheObjectDeleteException;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.NamenDto;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.impl.repos.ObjektnamenSortiererUtil;
import de.planetensuche.datenbankkern.querydsl5.Namen;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjektnamenRepository
implements IObjektnamenRepository,
SearchableDataSource {
    private final ILogging logger;
    private final QNamen qNamen = QNamen.namen1;
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCacheDao;

    @Inject
    public ObjektnamenRepository(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.logger = LoggingFactory.getLoggerForClass(ObjektnamenRepository.class);
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDao = iIdCacheDAO;
    }

    @Override
    public Integer readDatenid(String string) throws SQLException {
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.datenid).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.eq(string))).fetchFirst();
        return n;
    }

    @Override
    public Namen read(String string) throws SQLException {
        Namen namen = (Namen)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.eq(string))).fetchFirst();
        return namen;
    }

    @Override
    public void save(List<String> list, Integer n, ObjektnamenKlassifiziererService objektnamenKlassifiziererService) throws SQLException {
        Object object;
        Object object322;
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen).from((Expression<?>)this.qNamen)).where(this.qNamen.datenid.eq(n))).fetch();
        for (Object object322 : list2) {
            if (list.contains(((Namen)object322).getNamen())) continue;
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qNamen).where((Predicate)this.qNamen.id.eq(((Namen)object322).getId()))).execute();
        }
        ArrayList arrayList = new ArrayList();
        for (String object22 : list) {
            boolean iterator = true;
            for (Namen bl : list2) {
                if (!object22.equals(bl.getNamen())) continue;
                iterator = false;
                break;
            }
            if (!iterator) continue;
            arrayList.add(object22);
        }
        if (Check.isEmpty(arrayList)) {
            return;
        }
        object322 = new ArrayList<Object>();
        List list3 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.in(arrayList))).fetch();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            boolean namen = false;
            for (Namen namen2 : list3) {
                if (!((String)object).equals(namen2.getNamen())) continue;
                namen = true;
                if (namen2.getDatenid().intValue() == n.intValue()) break;
                namen2.setDatenid(n);
                ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qNamen).populate(namen2)).where((Predicate)this.qNamen.id.eq(namen2.getId()))).execute();
                break;
            }
            if (namen) continue;
            object322.add(object);
        }
        iterator = object322.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            try {
                Namen exception = new Namen();
                exception.setDatenid(n);
                exception.setNamen((String)object);
                exception.setIsbayerflamsteedgcvs2(objektnamenKlassifiziererService.isBayerFlamsteedGcvs2((String)object));
                if (exception.getIsbayerflamsteedgcvs2().booleanValue()) {
                    exception.setIseigenname(false);
                } else {
                    exception.setIseigenname(objektnamenKlassifiziererService.isCommonName((String)object));
                }
                ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qNamen).populate(exception)).execute();
            }
            catch (QueryException | SQLIntegrityConstraintViolationException exception) {
                this.logger.error("Fehler beim Einf\u00fcgen der neuen Bezeichnung '" + (String)object + "' (neue namen " + list.toString() + ")", exception);
            }
        }
    }

    @Override
    public Integer getIDFuerNamen(String string, boolean bl) throws SQLException {
        if (string == null) {
            throw new IllegalArgumentException("Objektname ist null!");
        }
        if (bl) {
            Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.datenid).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.eq(string))).fetchFirst();
            return n;
        }
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.datenid).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.equalsIgnoreCase(string.toLowerCase()))).fetchFirst();
        return n;
    }

    @Override
    public boolean gehoertZuEinerDatenid(List<String> list) throws SQLException {
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.datenid).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.in(list))).groupBy((Expression<?>)this.qNamen.datenid)).fetch();
        return list2.isEmpty() || list2.size() == 1;
    }

    @Override
    public Map<Integer, List<NamenDto>> findNamesByDatenids(List<Integer> list) {
        HashMap<Integer, List<NamenDto>> hashMap = new HashMap<Integer, List<NamenDto>>();
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen).from((Expression<?>)this.qNamen)).where(this.qNamen.datenid.in((Collection<Integer>)list))).fetch();
        for (Namen namen : list2) {
            hashMap.putIfAbsent(namen.getDatenid(), new ArrayList());
            NamenDto namenDto = new NamenDto();
            namenDto.setIdentifier(namen.getNamen());
            namenDto.setIsBayerFlamsteedGcvs2Name(namen.getIsbayerflamsteedgcvs2());
            namenDto.setIsCommonName(namen.getIseigenname());
            ((List)hashMap.get(namen.getDatenid())).add(namenDto);
        }
        return hashMap;
    }

    @Override
    public Map<Integer, List<String>> findNamenByDatenids(List<Integer> list) {
        HashMap<Integer, List<String>> hashMap = new HashMap<Integer, List<String>>();
        List list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen).from((Expression<?>)this.qNamen)).where(this.qNamen.datenid.in((Collection<Integer>)list))).fetch();
        for (Namen namen : list2) {
            hashMap.putIfAbsent(namen.getDatenid(), new ArrayList());
            ((List)hashMap.get(namen.getDatenid())).add(namen.getNamen());
        }
        return hashMap;
    }

    @Override
    public List<String> getNamenByDatenId(int n, ObjektnamenSortierung objektnamenSortierung) {
        switch (objektnamenSortierung) {
            case KEINE_SORTIERUNG: {
                return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.namen).from((Expression<?>)this.qNamen)).where(this.qNamen.datenid.eq(n))).fetch();
            }
            case ALPHABETISCH: {
                return ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.namen).from((Expression<?>)this.qNamen)).where(this.qNamen.datenid.eq(n))).orderBy((OrderSpecifier<?>)this.qNamen.namen.asc())).fetch();
            }
            case BEKANNTHEIT: {
                List<Namen> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen).from((Expression<?>)this.qNamen)).where(this.qNamen.datenid.eq(n))).fetch();
                return ObjektnamenSortiererUtil.sortiereNachBekanntheit(list);
            }
        }
        throw new UnsupportedOperationException("unknown sort order '" + String.valueOf((Object)objektnamenSortierung) + "'");
    }

    public void update(Namen namen) throws SQLException {
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qNamen).populate(namen)).where((Predicate)this.qNamen.id.eq(namen.getId()))).execute();
    }

    @Override
    public boolean removeNamen(String string) throws SQLException {
        Integer n = this.getIDFuerNamen(string, true);
        if (n == null) {
            return true;
        }
        List<String> list = this.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG);
        if (list.size() > 1) {
            SQLDeleteClause sQLDeleteClause = this.datenbankverbinder.getNewSqlDeleteClause(this.qNamen);
            sQLDeleteClause.where((Predicate)this.qNamen.namen.eq(string));
            return sQLDeleteClause.execute() == 1L;
        }
        if (list.size() == 1) {
            throw new PlanetensucheObjectDeleteException("Das Objekt '" + string + "' hat insgesamt nur 1 Namen!");
        }
        throw new PlanetensucheObjectDeleteException("Das Objekt '" + string + "' existiert nicht oder hat keinen Namen!");
    }

    @Override
    public List<String> getAllNames(boolean bl) throws SQLException {
        if (bl) {
            List<String> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.namen).from((Expression<?>)this.qNamen)).orderBy((OrderSpecifier<?>)this.qNamen.namen.asc())).fetch();
            return list;
        }
        List<String> list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.namen).from((Expression<?>)this.qNamen)).fetch();
        return list;
    }

    @Override
    public int countNames() throws SQLException {
        return (int)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.id).from((Expression<?>)this.qNamen)).fetchCount();
    }

    @Override
    public int countNamen(List<String> list) throws SQLException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Liste objektnamen ist leer!");
        }
        return (int)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.id).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.in(list))).fetchCount();
    }

    @Override
    public List<String> findAllForCategory(String string) throws SQLException {
        QKategorie qKategorie = QKategorie.kategorie;
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        QDaten qDaten = QDaten.daten;
        List<String> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.namen).from((Expression<?>)this.qNamen)).where(this.qNamen.datenid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(qKategorie.id).from((Expression<?>)qKategorie)).where(qKategorie.name.eq(string))))))))).fetch();
        return list;
    }

    @Override
    public List<Integer> getIdsFuerNamen(Collection<String> collection) throws SQLException {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Objektnamen sind null!");
        }
        List<Integer> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectDistinct((Expression)this.qNamen.datenid).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.in(collection))).fetch();
        return list;
    }

    @Override
    public int count(String string) throws SQLException {
        if (string == null || string.trim().length() < 3) {
            return 0;
        }
        long l = System.currentTimeMillis();
        long l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.count()).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.lower().eq(string.trim().toLowerCase()))).fetchCount();
        if (l2 == 0L) {
            l2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.count()).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.lower().startsWith(string.trim().toLowerCase()))).fetchCount();
        }
        if (this.logger.isDebugEnabled()) {
            long l3 = System.currentTimeMillis() - l;
            this.logger.debug("count(" + string + ") needs " + l3 + " ms, result=" + l2);
        }
        return (int)l2;
    }

    @Override
    public List<String> search(String string) throws SQLException {
        if (string == null || string.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        long l = System.currentTimeMillis();
        List<String> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.namen).from((Expression<?>)this.qNamen)).where(this.qNamen.namen.lower().startsWith(string.trim().toLowerCase()))).fetch();
        if (this.logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            this.logger.debug("search(" + string + ") needs " + l2 + " ms");
        }
        return list;
    }

    @Override
    public List<String> findCommonNames(ObjektKategorie ... objektKategorieArray) {
        if (Check.isEmpty(objektKategorieArray)) {
            return Collections.emptyList();
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        block10: for (ObjektKategorie objektKategorie : objektKategorieArray) {
            switch (objektKategorie) {
                case GALAXIE_NEBEL: 
                case GALAXIENHAUFEN: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsGalaxienundnebel());
                    continue block10;
                }
                case STERNE: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsSterne());
                    continue block10;
                }
                case STERNHAUFEN: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsSternhaufen());
                    continue block10;
                }
                case PLANETEN: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsPlaneten());
                    continue block10;
                }
                case BR_ZWERGE: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsBraunezwerge());
                    continue block10;
                }
                case MONDE: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsMonde());
                    continue block10;
                }
                case ASTEROIDEN: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsAsteroiden());
                    continue block10;
                }
                case KOMETEN: {
                    hashSet.addAll(this.idCacheDao.getObjekttypenidsKometen());
                    continue block10;
                }
                default: {
                    return new ArrayList<String>();
                }
            }
        }
        QDaten qDaten = QDaten.daten;
        List<String> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qNamen.namen).from((Expression<?>)this.qNamen)).leftJoin((EntityPath)qDaten)).on((Predicate)this.qNamen.datenid.eq(qDaten.id).and(this.qNamen.iseigenname.isTrue()))).where(this.qNamen.iseigenname.isTrue().and(qDaten.objektid.in((Collection<Integer>)hashSet)))).orderBy((OrderSpecifier<?>)this.qNamen.namen.asc())).fetch();
        return list;
    }
}

