/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IPhtEbCandidatesRepository;
import de.planetensuche.datenbankkern.api.repos.PhtEbCandidateAutoValidStatus;
import de.planetensuche.datenbankkern.api.repos.PhtEbCandidateDto;
import de.planetensuche.datenbankkern.querydsl5.PhtEbCandidateTags;
import de.planetensuche.datenbankkern.querydsl5.PhtEbCandidateTce;
import de.planetensuche.datenbankkern.querydsl5.PhtEbCandidates;
import de.planetensuche.datenbankkern.querydsl5.QPhtEbCandidatePages;
import de.planetensuche.datenbankkern.querydsl5.QPhtEbCandidateTags;
import de.planetensuche.datenbankkern.querydsl5.QPhtEbCandidateTce;
import de.planetensuche.datenbankkern.querydsl5.QPhtEbCandidates;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PhtEbCandidatesRepository
implements IPhtEbCandidatesRepository {
    private final QPhtEbCandidates phtEbsTable = QPhtEbCandidates.phtEbCandidates;
    private final QPhtEbCandidateTags phtEbsTagsTable = QPhtEbCandidateTags.phtEbCandidateTags;
    private final QPhtEbCandidatePages phtEbCandidatePagesTable = QPhtEbCandidatePages.phtEbCandidatePages;
    private final QPhtEbCandidateTce phtTceTable = QPhtEbCandidateTce.phtEbCandidateTce;
    private final IDatenbankverbinder datenbankverbinder;

    @Inject
    public PhtEbCandidatesRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public boolean entryExistsForSubjectAndTag(long l, String string) {
        PhtEbCandidateTags phtEbCandidateTags = (PhtEbCandidateTags)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.phtEbsTagsTable).where(this.phtEbsTagsTable.subjectId.eq(l).and(this.phtEbsTagsTable.tagName.eq(string)))).fetchOne();
        return phtEbCandidateTags != null;
    }

    @Override
    public void createEbCandidate(long l, long l2, String string, int n) throws SQLException {
        PhtEbCandidates phtEbCandidates = (PhtEbCandidates)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.phtEbsTable).where(this.phtEbsTable.ticId.eq(l2))).fetchOne();
        if (phtEbCandidates == null) {
            ((SQLInsertClause)((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.phtEbsTable).columns(new Path[]{this.phtEbsTable.ticId, this.phtEbsTable.autoValid})).values(new Object[]{l2, PhtEbCandidateAutoValidStatus.TBD.name()})).execute();
        }
        ((SQLInsertClause)((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.phtEbsTagsTable).columns(new Path[]{this.phtEbsTagsTable.subjectId, this.phtEbsTagsTable.ticId, this.phtEbsTagsTable.tagName, this.phtEbsTagsTable.count})).values(new Object[]{l, l2, string, n})).execute();
    }

    @Override
    public int getEbTagCountForTicId(long l) {
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.phtEbsTagsTable.count).from((Expression<?>)this.phtEbsTagsTable)).where(this.phtEbsTagsTable.ticId.eq(l))).fetch();
        return list.stream().mapToInt(Integer::intValue).sum();
    }

    @Override
    public void saveAutoValidStatus(long l, PhtEbCandidateAutoValidStatus phtEbCandidateAutoValidStatus) throws SQLException {
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.phtEbsTable).set((Path)this.phtEbsTable.autoValid, phtEbCandidateAutoValidStatus.name())).where((Predicate)this.phtEbsTable.ticId.eq(l))).execute();
    }

    @Override
    public void saveAutoValidStatus(long l, PhtEbCandidateAutoValidStatus phtEbCandidateAutoValidStatus, String string) throws SQLException {
        ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.phtEbsTable).set((Path)this.phtEbsTable.autoValid, phtEbCandidateAutoValidStatus.name())).set((Path)this.phtEbsTable.ebCatalog, string)).where((Predicate)this.phtEbsTable.ticId.eq(l))).execute();
    }

    @Override
    public List<PhtEbCandidateDto> findAll() {
        Object object2;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.phtEbsTable.ticId, this.phtEbsTable.autoValid, this.phtEbsTable.ebCatalog, this.phtEbsTagsTable.count, this.phtEbsTagsTable.subjectId, this.phtEbsTagsTable.tagName}).from((Expression<?>)this.phtEbsTable)).join((EntityPath)this.phtEbsTagsTable)).on((Predicate)this.phtEbsTable.ticId.eq(this.phtEbsTagsTable.ticId))).where(this.phtEbsTable.autoValid.ne("TBD"))).fetch();
        HashMap hashMap = new HashMap();
        HashMap<Long, Integer> hashMap2 = new HashMap<Long, Integer>();
        HashMap hashMap3 = new HashMap();
        HashMap<Long, String> hashMap4 = new HashMap<Long, String>();
        HashMap<Long, PhtEbCandidateAutoValidStatus> hashMap5 = new HashMap<Long, PhtEbCandidateAutoValidStatus>();
        for (Object object2 : list) {
            long l = object2.get(this.phtEbsTable.ticId);
            long l2 = object2.get(this.phtEbsTagsTable.subjectId);
            int n = object2.get(this.phtEbsTagsTable.count);
            String string = object2.get(this.phtEbsTagsTable.tagName);
            Integer n2 = (Integer)hashMap2.get(l);
            n2 = n2 == null ? Integer.valueOf(n) : Integer.valueOf(n2 + n);
            hashMap2.put(l, n2);
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashSet.add(string);
                hashMap.put(l, hashSet);
            } else if (!hashSet.contains(string)) {
                hashSet.add(string);
                hashMap.put(l, hashSet);
            }
            HashSet<Long> hashSet2 = (HashSet<Long>)hashMap3.get(l);
            if (hashSet2 == null) {
                hashSet2 = new HashSet<Long>();
                hashSet2.add(l2);
                hashMap3.put(l, hashSet2);
            } else if (!hashSet2.contains(l2)) {
                hashSet2.add(l2);
                hashMap3.put(l, hashSet2);
            }
            PhtEbCandidateAutoValidStatus phtEbCandidateAutoValidStatus = PhtEbCandidateAutoValidStatus.valueOf(object2.get(this.phtEbsTable.autoValid));
            hashMap5.put(l, phtEbCandidateAutoValidStatus);
            String string2 = object2.get(this.phtEbsTable.ebCatalog);
            hashMap4.put(l, string2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashMap5.keySet());
        Collections.sort(arrayList);
        object2 = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            object2.add(new PhtEbCandidateDto(l, (Set)hashMap3.get(l), (Set)hashMap.get(l), (Integer)hashMap2.get(l), (String)hashMap4.get(l), (PhtEbCandidateAutoValidStatus)((Object)hashMap5.get(l))));
        }
        return object2;
    }

    @Override
    public List<Long> findUnanalyzedTargets() {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.phtEbsTable.ticId).from((Expression<?>)this.phtEbsTable)).where(this.phtEbsTable.autoValid.eq(PhtEbCandidateAutoValidStatus.TBD.name()))).fetch();
    }

    @Override
    public List<Long> findMissingGaiaData() {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.phtEbsTable.ticId).from((Expression<?>)this.phtEbsTable)).where(this.phtEbsTable.datenid.isNull().or(this.phtEbsTable.datenid.eq(1)))).fetch();
    }

    @Override
    public void savePsObjectLink(long l, int n) throws SQLException {
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.phtEbsTable).set((Path)this.phtEbsTable.datenid, (Object)n)).where((Predicate)this.phtEbsTable.ticId.eq(l))).execute();
    }

    @Override
    public int getNextPageForTag(String string) {
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.phtEbCandidatePagesTable.currentPageNo).from((Expression<?>)this.phtEbCandidatePagesTable)).where(this.phtEbCandidatePagesTable.tagName.eq(string))).fetchOne();
        return n != null && n >= 1 ? n : 1;
    }

    @Override
    public void saveProcessedPage(String string, int n) throws SQLException {
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.phtEbCandidatePagesTable.id).from((Expression<?>)this.phtEbCandidatePagesTable)).where(this.phtEbCandidatePagesTable.tagName.eq(string))).fetchOne();
        if (n2 == null) {
            ((SQLInsertClause)((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.phtEbCandidatePagesTable).columns(new Path[]{this.phtEbCandidatePagesTable.tagName, this.phtEbCandidatePagesTable.currentPageNo})).values(new Object[]{string, n})).execute();
        } else {
            ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.phtEbCandidatePagesTable).set((Path)this.phtEbCandidatePagesTable.currentPageNo, (Object)n)).where((Predicate)this.phtEbCandidatePagesTable.tagName.eq(string))).execute();
        }
    }

    @Override
    public List<Long> findKnownEbs() {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.phtEbsTable.ticId).from((Expression<?>)this.phtEbsTable)).where(this.phtEbsTable.autoValid.eq(PhtEbCandidateAutoValidStatus.KNOWN_EB.name()))).fetch();
    }

    @Override
    public PhtEbCandidateTce getTceForTic(long l) {
        return (PhtEbCandidateTce)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.phtTceTable).where(this.phtTceTable.ticId.eq(l))).fetchOne();
    }

    @Override
    public void saveTceEntry(PhtEbCandidateTce phtEbCandidateTce) throws SQLException {
        if (this.getTceForTic(phtEbCandidateTce.getTicId()) == null) {
            ((SQLInsertClause)((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.phtTceTable).columns(new Path[]{this.phtTceTable.ticId, this.phtTceTable.period1, this.phtTceTable.period2, this.phtTceTable.period3, this.phtTceTable.period4, this.phtTceTable.period5, this.phtTceTable.period6, this.phtTceTable.targetOffset1, this.phtTceTable.targetOffset2, this.phtTceTable.targetOffset3, this.phtTceTable.targetOffset4, this.phtTceTable.targetOffset5, this.phtTceTable.targetOffset6, this.phtTceTable.numSectors1, this.phtTceTable.numSectors2, this.phtTceTable.numSectors3, this.phtTceTable.numSectors4, this.phtTceTable.numSectors5, this.phtTceTable.numSectors6})).values(new Object[]{phtEbCandidateTce.getTicId(), phtEbCandidateTce.getPeriod1(), phtEbCandidateTce.getPeriod2(), phtEbCandidateTce.getPeriod3(), phtEbCandidateTce.getPeriod4(), phtEbCandidateTce.getPeriod5(), phtEbCandidateTce.getPeriod6(), phtEbCandidateTce.getTargetOffset1(), phtEbCandidateTce.getTargetOffset2(), phtEbCandidateTce.getTargetOffset3(), phtEbCandidateTce.getTargetOffset4(), phtEbCandidateTce.getTargetOffset5(), phtEbCandidateTce.getTargetOffset6(), phtEbCandidateTce.getNumSectors1(), phtEbCandidateTce.getNumSectors2(), phtEbCandidateTce.getNumSectors3(), phtEbCandidateTce.getNumSectors4(), phtEbCandidateTce.getNumSectors5(), phtEbCandidateTce.getNumSectors6()})).execute();
        } else {
            ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.phtTceTable).set((Path)this.phtTceTable.period1, phtEbCandidateTce.getPeriod1())).set((Path)this.phtTceTable.period2, phtEbCandidateTce.getPeriod2())).set((Path)this.phtTceTable.period3, phtEbCandidateTce.getPeriod3())).set((Path)this.phtTceTable.period4, phtEbCandidateTce.getPeriod4())).set((Path)this.phtTceTable.period5, phtEbCandidateTce.getPeriod5())).set((Path)this.phtTceTable.period6, phtEbCandidateTce.getPeriod6())).set((Path)this.phtTceTable.targetOffset1, phtEbCandidateTce.getTargetOffset1())).set((Path)this.phtTceTable.targetOffset2, phtEbCandidateTce.getTargetOffset2())).set((Path)this.phtTceTable.targetOffset3, phtEbCandidateTce.getTargetOffset3())).set((Path)this.phtTceTable.targetOffset4, phtEbCandidateTce.getTargetOffset4())).set((Path)this.phtTceTable.targetOffset5, phtEbCandidateTce.getTargetOffset5())).set((Path)this.phtTceTable.targetOffset6, phtEbCandidateTce.getTargetOffset6())).set((Path)this.phtTceTable.numSectors1, phtEbCandidateTce.getNumSectors1())).set((Path)this.phtTceTable.numSectors2, phtEbCandidateTce.getNumSectors2())).set((Path)this.phtTceTable.numSectors3, phtEbCandidateTce.getNumSectors3())).set((Path)this.phtTceTable.numSectors4, phtEbCandidateTce.getNumSectors4())).set((Path)this.phtTceTable.numSectors5, phtEbCandidateTce.getNumSectors5())).set((Path)this.phtTceTable.numSectors6, phtEbCandidateTce.getNumSectors6())).where((Predicate)this.phtTceTable.ticId.eq(phtEbCandidateTce.getTicId()))).execute();
        }
    }

    @Override
    public long countTceEntries() {
        return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.phtTceTable.count()).from((Expression<?>)this.phtTceTable)).fetchCount();
    }
}

