/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IPhtTransitMatchesRepository;
import de.planetensuche.datenbankkern.querydsl5.PhtTransitMatches;
import de.planetensuche.datenbankkern.querydsl5.QPhtTransitMatches;
import java.sql.SQLException;
import java.util.List;

public final class PhtTransitMatchesRepository
implements IPhtTransitMatchesRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final QPhtTransitMatches qPhtTransitMatches = QPhtTransitMatches.phtTransitMatches;

    @Inject
    public PhtTransitMatchesRepository(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    @Override
    public boolean existsPlanet(String string) {
        return this.read(string) != null;
    }

    @Override
    public void save(PhtTransitMatches phtTransitMatches) throws SQLException {
        if (phtTransitMatches.getId() == null) {
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qPhtTransitMatches).populate(phtTransitMatches)).execute();
        } else {
            ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qPhtTransitMatches).set((Path)this.qPhtTransitMatches.checked, phtTransitMatches.getChecked())).set((Path)this.qPhtTransitMatches.epochBjd, phtTransitMatches.getEpochBjd())).set((Path)this.qPhtTransitMatches.epochBjdError, phtTransitMatches.getEpochBjdError())).set((Path)this.qPhtTransitMatches.exofopState, phtTransitMatches.getExofopState())).set((Path)this.qPhtTransitMatches.matchedSubjectId, phtTransitMatches.getMatchedSubjectId())).set((Path)this.qPhtTransitMatches.periodDays, phtTransitMatches.getPeriodDays())).set((Path)this.qPhtTransitMatches.periodDaysError, phtTransitMatches.getPeriodDaysError())).set((Path)this.qPhtTransitMatches.userComment, phtTransitMatches.getUserComment())).where((Predicate)this.qPhtTransitMatches.id.eq(phtTransitMatches.getId()))).execute();
        }
    }

    @Override
    public List<PhtTransitMatches> findUnprocessedList() {
        List<PhtTransitMatches> list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qPhtTransitMatches).where(this.qPhtTransitMatches.checked.isFalse())).fetch();
        return list;
    }

    @Override
    public List<PhtTransitMatches> findScanResults() {
        List<PhtTransitMatches> list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qPhtTransitMatches).where(this.qPhtTransitMatches.matchedSubjectId.isNotNull())).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{this.qPhtTransitMatches.exofopEntryCreated.asc(), this.qPhtTransitMatches.id.asc()})).fetch();
        return list;
    }

    @Override
    public PhtTransitMatches read(String string) {
        PhtTransitMatches phtTransitMatches = (PhtTransitMatches)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qPhtTransitMatches).where(this.qPhtTransitMatches.planetId.eq(string))).fetchOne();
        return phtTransitMatches;
    }

    @Override
    public void resetScanResults() throws SQLException {
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qPhtTransitMatches).set((Path)this.qPhtTransitMatches.checked, (Object)false)).where((Predicate)this.qPhtTransitMatches.matchedSubjectId.isNull())).execute();
    }

    @Override
    public long countMatchesWithExofopState(String string) {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qPhtTransitMatches.count()).from((Expression<?>)this.qPhtTransitMatches)).where(this.qPhtTransitMatches.matchedSubjectId.isNotNull().and(this.qPhtTransitMatches.exofopState.eq(string)))).fetchCount();
    }

    @Override
    public long countMatchesWithExofopState(List<String> list) {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qPhtTransitMatches.count()).from((Expression<?>)this.qPhtTransitMatches)).where(this.qPhtTransitMatches.matchedSubjectId.isNotNull().and(this.qPhtTransitMatches.exofopState.in(list)))).fetchCount();
    }

    @Override
    public long countAllPlanets() {
        return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qPhtTransitMatches.planetId.count()).from((Expression<?>)this.qPhtTransitMatches)).fetchCount();
    }

    @Override
    public long countAllStars() {
        return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qPhtTransitMatches.count()).from((Expression<?>)this.qPhtTransitMatches)).groupBy((Expression<?>)this.qPhtTransitMatches.ticId)).fetchCount();
    }
}

