/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datamodel.impl.PsObjektService;
import de.planetensuche.datenbankkern.api.IDatenbankBeobachter;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.exceptions.PlanetensucheSQLException;
import de.planetensuche.datenbankkern.api.repos.GaiaStarsEntity;
import de.planetensuche.datenbankkern.api.repos.IDatenPojoIdMapper;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.api.repos.IGaiaStarsRepository;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.INotizenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektalterRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.Daten;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.Objektalter;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QNotizen;
import de.planetensuche.datenbankkern.querydsl5.QObjektalter;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.datenbankkern.querydsl5.Sternbilder;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class PlanetensucheObjektRepository
implements IPlanetensucheObjektRepository {
    private final QDaten qDaten = QDaten.daten;
    private final IDatenbankverbinder datenbankverbinder;
    private final IObjektnamenRepository objektnamenRepository;
    private final ISternbilderRepository sternbilderRepository;
    private final IZwischentabellenRepository zwischentabellenRepository;
    private final IEntdeckerRepository entdeckerRepository;
    private final IObjektalterRepository objektalterRepository;
    private final IDatenPojoIdMapper mapper;
    private PsObjektService psService;
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final INotizenRepository notizenRepo;
    private final IHabitableZoneRepository habitableZoneRepository;
    private final IGaiaStarsRepository gaiaStarRepo;

    @Inject
    public PlanetensucheObjektRepository(IDatenbankverbinder iDatenbankverbinder, IObjektnamenRepository iObjektnamenRepository, ISternbilderRepository iSternbilderRepository, IZwischentabellenRepository iZwischentabellenRepository, IEntdeckerRepository iEntdeckerRepository, IObjektalterRepository iObjektalterRepository, IDatenPojoIdMapper iDatenPojoIdMapper, INotizenRepository iNotizenRepository, IHabitableZoneRepository iHabitableZoneRepository, IGaiaStarsRepository iGaiaStarsRepository) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.objektnamenRepository = iObjektnamenRepository;
        this.sternbilderRepository = iSternbilderRepository;
        this.zwischentabellenRepository = iZwischentabellenRepository;
        this.entdeckerRepository = iEntdeckerRepository;
        this.objektalterRepository = iObjektalterRepository;
        this.mapper = iDatenPojoIdMapper;
        this.notizenRepo = iNotizenRepository;
        this.habitableZoneRepository = iHabitableZoneRepository;
        this.gaiaStarRepo = iGaiaStarsRepository;
    }

    public void setPsService(PsObjektService psObjektService) {
        this.psService = psObjektService;
    }

    @Override
    public void create(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer, boolean bl, ObjektnamenKlassifiziererService objektnamenKlassifiziererService) throws SQLException, IOException {
        if (iPlanetensucheObjektPruefer.getDatenid() != null) {
            throw new IllegalArgumentException("Objekt mit id " + iPlanetensucheObjektPruefer.getDatenid() + " kann nicht erneut eingefuegt werden!");
        }
        this.validiereObjektUndBerechneFehlendeDaten(iPlanetensucheObjektPruefer, bl);
        Daten daten = this.getPojoVomPsObjekt(iPlanetensucheObjektPruefer);
        Integer n = ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qDaten).populate(daten)).executeWithKey(this.qDaten.id);
        iPlanetensucheObjektPruefer.setDatenid(n);
        this.objektnamenRepository.save(iPlanetensucheObjektPruefer.getObjektNamen(), n, objektnamenKlassifiziererService);
        if (!iPlanetensucheObjektPruefer.isAlterInMrdJahreUnbekannt()) {
            this.objektalterRepository.save(n, iPlanetensucheObjektPruefer.getAlterInMrdJahre());
        }
        if (!iPlanetensucheObjektPruefer.isSternbildUnbekannt() || !iPlanetensucheObjektPruefer.getBilder().isEmpty()) {
            Integer n2 = this.sternbilderRepository.getId(iPlanetensucheObjektPruefer.getSternbildCode());
            this.zwischentabellenRepository.save(n2, n, iPlanetensucheObjektPruefer.getBilder());
        }
        for (Map.Entry entry : iPlanetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen().entrySet()) {
            Integer n3 = this.entdeckerRepository.getId((String)entry.getKey(), (String)entry.getValue());
            if (n3 == null) continue;
            this.zwischentabellenRepository.save(n, n3);
        }
        if (iPlanetensucheObjektPruefer.getNotiz() != null && !iPlanetensucheObjektPruefer.getNotiz().isEmpty()) {
            this.notizenRepo.save(n, iPlanetensucheObjektPruefer.getNotiz());
        }
        if (ObjektKategorie.STERNE.getKategorienName().equals(iPlanetensucheObjektPruefer.getKategorie())) {
            this.habitableZoneRepository.calculateAndSave(iPlanetensucheObjektPruefer);
            this.gaiaStarRepo.save(iPlanetensucheObjektPruefer);
        }
    }

    @Override
    public List<IPlanetensucheObjekt> read(List<Integer> list) throws SQLException {
        List list2 = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.id.in((Collection<Integer>)list))).fetch();
        Map<Integer, IPlanetensucheObjekt> map = list2.parallelStream().collect(Collectors.toMap(daten -> daten.getId(), daten -> {
            try {
                return this.createPlanetensucheObjektForDatenEntity((Daten)daten);
            }
            catch (SQLException sQLException) {
                this.logger.error(sQLException);
                return null;
            }
        }));
        ArrayList<IPlanetensucheObjekt> arrayList = new ArrayList<IPlanetensucheObjekt>();
        for (Integer n : list) {
            IPlanetensucheObjekt iPlanetensucheObjekt = map.get(n);
            if (iPlanetensucheObjekt == null) continue;
            arrayList.add(iPlanetensucheObjekt);
        }
        return arrayList;
    }

    @Override
    public IPlanetensucheObjekt read(Integer n) throws SQLException {
        if (n == null) {
            throw new IllegalArgumentException("id ist null");
        }
        Daten daten = (Daten)((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.id.eq(n))).fetchOne();
        if (daten == null) {
            throw new IllegalArgumentException("kein Objekt f\u00fcr id " + n + " gefunden");
        }
        IPlanetensucheObjekt iPlanetensucheObjekt = this.createPlanetensucheObjektForDatenEntity(daten);
        return iPlanetensucheObjekt;
    }

    private IPlanetensucheObjekt createPlanetensucheObjektForDatenEntity(Daten daten) throws SQLException {
        GaiaStarsEntity gaiaStarsEntity;
        Object object;
        Integer n = daten.getId();
        PlanetensucheObjekt planetensucheObjekt = new PlanetensucheObjekt();
        if (daten.getAh() != null) {
            planetensucheObjekt.setAbsoluteHelligkeit(daten.getAh());
        }
        if (daten.getAlbedo() != null) {
            planetensucheObjekt.setAlbedo(daten.getAlbedo());
        }
        planetensucheObjekt.setAutor(daten.getAutor());
        if (daten.getBv() != null) {
            planetensucheObjekt.setBV(daten.getBv());
        }
        if (daten.getDecl() != null) {
            planetensucheObjekt.setDECL(daten.getDecl());
        }
        planetensucheObjekt.setDatenid(n);
        if (daten.getDurchmesser() != null) {
            planetensucheObjekt.setDurchmesser(daten.getDurchmesser());
        }
        planetensucheObjekt.setEntdeckungsdatum(daten.getEntdeckungsdatum());
        planetensucheObjekt.setEntdeckungsjahr(daten.getEntdeckungsjahr());
        if (daten.getEntfernung() != null) {
            planetensucheObjekt.setEntfernung(daten.getEntfernung());
        }
        if (daten.getExzentritaet() != null) {
            planetensucheObjekt.setExzentritaet(daten.getExzentritaet());
        }
        if (daten.getFlaechenhelligkeit() != null) {
            planetensucheObjekt.setFlaechenhelligkeit(daten.getFlaechenhelligkeit());
        }
        if (daten.getDurchmesser2() != null) {
            planetensucheObjekt.setGalaxienDurchmesserInLy(daten.getDurchmesser2());
        }
        if (daten.getGeschwindigkeit() != null) {
            planetensucheObjekt.setGeschwindigkeit(daten.getGeschwindigkeit());
        }
        if (daten.getMasse() != null) {
            planetensucheObjekt.setMasse(daten.getMasse());
        }
        if (daten.getMetallizitaet() != null) {
            planetensucheObjekt.setMetallizitaet(daten.getMetallizitaet());
        }
        if (daten.getRa() != null) {
            planetensucheObjekt.setRA(daten.getRa());
        }
        if (daten.getRotverschiebung() != null) {
            planetensucheObjekt.setRotverschiebung(daten.getRotverschiebung());
        }
        if (daten.getSh() != null) {
            planetensucheObjekt.setScheinbareHelligkeit(daten.getSh());
        }
        planetensucheObjekt.setStamp(daten.getStamp());
        if (daten.getSternentstehung() != null) {
            planetensucheObjekt.setSternentstehung(daten.getSternentstehung());
        }
        if (daten.getTemperatur() != null) {
            planetensucheObjekt.setTemperatur(daten.getTemperatur());
        }
        if (daten.getUmlaufszeit() != null) {
            planetensucheObjekt.setUmlaufszeit(daten.getUmlaufszeit());
        }
        if (daten.getEntdeckungbestaetigt() != null) {
            planetensucheObjekt.setEntdeckungBestaetigt(daten.getEntdeckungbestaetigt());
        }
        this.mapper.mapIds(daten, planetensucheObjekt);
        List<String> list = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG);
        planetensucheObjekt.setObjektNamen(new HashSet<String>(list));
        if (daten.getZugehoerigkeit() != null) {
            planetensucheObjekt.setUmkreistDatenId(daten.getZugehoerigkeit());
            object = this.objektnamenRepository.getNamenByDatenId(daten.getZugehoerigkeit(), ObjektnamenSortierung.KEINE_SORTIERUNG);
            planetensucheObjekt.setUmkreistObjekt((String)object.get(0));
        }
        this.setzteKindobjekte(n, planetensucheObjekt);
        object = this.objektalterRepository.read(n);
        if (object != null) {
            planetensucheObjekt.setAlterInMrdJahre(((Objektalter)object).getAlter());
        }
        Set<String> set = this.zwischentabellenRepository.getBilder(n);
        planetensucheObjekt.setBilder(set);
        this.setzteSternbild(n, planetensucheObjekt);
        this.setzteEntdecker(n, planetensucheObjekt);
        String string = this.notizenRepo.getByDatenid(n);
        planetensucheObjekt.setNotiz(string);
        if (planetensucheObjekt.getCategory().equals((Object)ObjektKategorie.STERNE) && (gaiaStarsEntity = this.gaiaStarRepo.readByDatenId(n)) != null) {
            if (gaiaStarsEntity.getAstroExNoiseSig() != null) {
                planetensucheObjekt.setGaiaAstroExNoiseSig(gaiaStarsEntity.getAstroExNoiseSig());
            }
            planetensucheObjekt.setGaiaNonSingle(gaiaStarsEntity.getNonSingleEnum());
            if (gaiaStarsEntity.getRuwe() != null) {
                planetensucheObjekt.setGaiaRuwe(gaiaStarsEntity.getRuwe());
            }
            if (gaiaStarsEntity.getRvError() != null) {
                planetensucheObjekt.setGaiaRvError(gaiaStarsEntity.getRvError());
            }
        }
        return planetensucheObjekt;
    }

    @Override
    public void update(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer, boolean bl, ObjektnamenKlassifiziererService objektnamenKlassifiziererService) throws SQLException, IOException {
        Integer n = iPlanetensucheObjektPruefer.getDatenid();
        if (n == null) {
            for (String object2 : iPlanetensucheObjektPruefer.getObjektNamen()) {
                Integer n2 = this.objektnamenRepository.readDatenid(object2);
                if (n2 == null) continue;
                n = n2;
                break;
            }
        }
        if (n == null) {
            throw new IllegalArgumentException("datenId ist null f\u00fcr objekt " + String.valueOf(iPlanetensucheObjektPruefer.getObjektNamen()) + "!");
        }
        this.validiereObjektUndBerechneFehlendeDaten(iPlanetensucheObjektPruefer, bl);
        Daten daten = this.getPojoVomPsObjekt(iPlanetensucheObjektPruefer);
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qDaten).populate(daten)).where((Predicate)this.qDaten.id.eq(n))).execute();
        this.objektnamenRepository.save(iPlanetensucheObjektPruefer.getObjektNamen(), n, objektnamenKlassifiziererService);
        if (iPlanetensucheObjektPruefer.isAlterInMrdJahreUnbekannt()) {
            Integer n3 = this.objektalterRepository.getId(n);
            if (n3 != null) {
                this.objektalterRepository.delete(n3);
            }
        } else {
            this.objektalterRepository.save(n, iPlanetensucheObjektPruefer.getAlterInMrdJahre());
        }
        Integer n4 = this.sternbilderRepository.getId(iPlanetensucheObjektPruefer.getSternbildCode());
        this.zwischentabellenRepository.save(n4, n, iPlanetensucheObjektPruefer.getBilder());
        this.zwischentabellenRepository.deleteEntdecker(n);
        for (Map.Entry entry : iPlanetensucheObjektPruefer.getEntdeckerMitNachnamenVornamen().entrySet()) {
            Integer n5 = this.entdeckerRepository.getId((String)entry.getKey(), (String)entry.getValue());
            if (n5 == null) continue;
            this.zwischentabellenRepository.save(n, n5);
        }
        this.notizenRepo.save(n, iPlanetensucheObjektPruefer.getNotiz());
        if (ObjektKategorie.STERNE.getKategorienName().equals(iPlanetensucheObjektPruefer.getKategorie())) {
            this.habitableZoneRepository.calculateAndSave(iPlanetensucheObjektPruefer);
            this.gaiaStarRepo.save(iPlanetensucheObjektPruefer);
        }
    }

    @Override
    public void delete(Integer n) throws SQLException {
        QNotizen qNotizen = QNotizen.notizen;
        QZt qZt = QZt.zt;
        QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
        QObjektalter qObjektalter = QObjektalter.objektalter;
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.zugehoerigkeit.eq(n))).fetch();
        if (Check.isFilled(list)) {
            throw new SQLIntegrityConstraintViolationException("datenid " + n + " hat noch " + list.size() + " Kindobjekte und kann nicht gel\u00f6scht werden");
        }
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZt).where((Predicate)qZt.datenid.eq(n))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qZtentdecker).where((Predicate)qZtentdecker.datenid.eq(n))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qObjektalter).where((Predicate)qObjektalter.datenid.eq(n))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNotizen).where((Predicate)qNotizen.datenid.eq(n))).execute();
        this.habitableZoneRepository.delete(n);
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(qNamen).where((Predicate)qNamen.datenid.eq(n))).execute();
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qDaten).where((Predicate)this.qDaten.id.eq(n))).execute();
    }

    @Override
    public IPlanetensucheObjekt read(String string) throws SQLException {
        Integer n = this.objektnamenRepository.readDatenid(string);
        return this.read(n);
    }

    @Override
    public void setAllData(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer, boolean bl, IDatenbankBeobachter iDatenbankBeobachter, ObjektnamenKlassifiziererService objektnamenKlassifiziererService) {
        try {
            if (iPlanetensucheObjektPruefer.getDatenid() == null) {
                this.create(iPlanetensucheObjektPruefer, bl, objektnamenKlassifiziererService);
            } else {
                this.update(iPlanetensucheObjektPruefer, bl, objektnamenKlassifiziererService);
            }
        }
        catch (IOException | SQLException exception) {
            this.logger.error(exception);
            iDatenbankBeobachter.nachBatchEnde(new PlanetensucheSQLException(exception.toString()), false, iPlanetensucheObjektPruefer.getObjektNamen().get(0));
        }
    }

    @Override
    public void updateReferences(Integer n, Integer n2) throws SQLException {
        ((SQLUpdateClause)((SQLUpdateClause)this.datenbankverbinder.getNewSqlUpdateClause(this.qDaten).where((Predicate)this.qDaten.zugehoerigkeit.eq(n2))).set((Path)this.qDaten.zugehoerigkeit, n)).execute();
    }

    private void setzteKindobjekte(Integer n, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.zugehoerigkeit.eq(n))).fetch();
        for (Integer n2 : list) {
            List<String> list2 = this.objektnamenRepository.getNamenByDatenId(n2, ObjektnamenSortierung.KEINE_SORTIERUNG);
            hashSet.addAll(list2);
            hashSet2.add(n2);
        }
        iPlanetensucheObjekt.setWirdUmkreistVon(hashSet);
        iPlanetensucheObjekt.setWirdUmkreistVonIDs(hashSet2);
    }

    private void setzteEntdecker(Integer n, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        List<Entdecker> list = this.zwischentabellenRepository.getEntdecker(n);
        for (Entdecker entdecker : list) {
            hashMap.put(entdecker.getNachname(), entdecker.getFachgebiet());
            hashMap2.put(entdecker.getNachname(), entdecker.getVorname());
        }
        iPlanetensucheObjekt.setEntdeckerMitNachnamenFachgebiete(hashMap);
        iPlanetensucheObjekt.setEntdeckerMitNachnamenVornamen(hashMap2);
    }

    private void setzteSternbild(Integer n, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        Sternbilder sternbilder = this.zwischentabellenRepository.getSternbild(n);
        if (sternbilder != null) {
            iPlanetensucheObjekt.setSternbildCode(sternbilder.getLatabk());
            iPlanetensucheObjekt.setSternbildDTBezeichnung(sternbilder.getDtbezeichnung());
            iPlanetensucheObjekt.setSternbildENGBezeichnung(sternbilder.getEngbezeichnung());
            iPlanetensucheObjekt.setSternbildLATBezeichnung(sternbilder.getLatbezeichnung());
        }
    }

    private void validiereObjektUndBerechneFehlendeDaten(IPlanetensucheObjekt iPlanetensucheObjekt, boolean bl) throws SQLException, IOException {
        if (iPlanetensucheObjekt.getCategory() == null || iPlanetensucheObjekt.getCategory() == ObjektKategorie.UNDEFINED) {
            throw new IllegalArgumentException("Object category is not set!");
        }
        if (Check.isEmpty(iPlanetensucheObjekt.getObjekttyp())) {
            throw new IllegalArgumentException("Object type is empty!");
        }
        if (Check.isEmpty(iPlanetensucheObjekt.getObjektNamen())) {
            throw new IllegalArgumentException("Object names are empty!");
        }
        this.checkMultipleObjects(iPlanetensucheObjekt);
        if (bl) {
            if (this.psService == null) {
                this.psService = new PsObjektService(false);
            }
            this.psService.starteBerechnung(iPlanetensucheObjekt);
        }
    }

    private void checkMultipleObjects(IPlanetensucheObjekt iPlanetensucheObjekt) throws PlanetensucheSQLException, SQLException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (String string : iPlanetensucheObjekt.getObjektNamen()) {
            Integer n = this.objektnamenRepository.readDatenid(string);
            if (n == null) continue;
            hashSet.add(n);
        }
        if (hashSet.size() == 1) {
            iPlanetensucheObjekt.setDatenid((Integer)hashSet.iterator().next());
        } else if (hashSet.size() > 1) {
            throw new PlanetensucheSQLException("Die Bezeichnungen des Objektes '" + iPlanetensucheObjekt.getObjektNamen().get(0) + "' verweisen auf mehrere andere Objekte. Das Objekt kann daher nicht gespeichert werden.");
        }
    }

    private Daten getPojoVomPsObjekt(IPlanetensucheObjektPruefer iPlanetensucheObjektPruefer) throws SQLException {
        Daten daten = new Daten();
        daten.setAh(iPlanetensucheObjektPruefer.getAbsoluteHelligkeit());
        daten.setAlbedo(iPlanetensucheObjektPruefer.getAlbedo());
        daten.setAutor(iPlanetensucheObjektPruefer.getAutor());
        daten.setBv(iPlanetensucheObjektPruefer.getBV());
        daten.setDecl(iPlanetensucheObjektPruefer.getDECL());
        daten.setDurchmesser(iPlanetensucheObjektPruefer.getDurchmesser());
        daten.setDurchmesser2(iPlanetensucheObjektPruefer.getGalaxienDurchmesserInLy());
        daten.setEntdeckungsdatum(iPlanetensucheObjektPruefer.getEntdeckungsdatum());
        if (Check.isFilled(daten.getEntdeckungsdatum()) && daten.getEntdeckungsdatum().length() >= 4) {
            int n = Integer.parseInt(daten.getEntdeckungsdatum().substring(daten.getEntdeckungsdatum().length() - 4));
            daten.setEntdeckungsjahr(n);
        } else if ((double)iPlanetensucheObjektPruefer.getEntdeckungsjahr() != 0.0) {
            daten.setEntdeckungsjahr(iPlanetensucheObjektPruefer.getEntdeckungsjahr());
        }
        daten.setEntfernung(iPlanetensucheObjektPruefer.getEntfernung());
        daten.setExzentritaet(iPlanetensucheObjektPruefer.getExzentritaet());
        daten.setFlaechenhelligkeit(iPlanetensucheObjektPruefer.getFlaechenhelligkeit());
        daten.setGeschwindigkeit(iPlanetensucheObjektPruefer.getGeschwindigkeit());
        daten.setMasse(iPlanetensucheObjektPruefer.getMasse());
        daten.setMetallizitaet(iPlanetensucheObjektPruefer.getMetallizitaet());
        daten.setRa(iPlanetensucheObjektPruefer.getRA());
        daten.setRotverschiebung(iPlanetensucheObjektPruefer.getRotverschiebung());
        daten.setSh(iPlanetensucheObjektPruefer.getScheinbareHelligkeit());
        daten.setStamp(iPlanetensucheObjektPruefer.getStamp());
        daten.setSternentstehung(iPlanetensucheObjektPruefer.getSternentstehung());
        daten.setTemperatur(iPlanetensucheObjektPruefer.getTemperatur());
        daten.setUmlaufszeit(iPlanetensucheObjektPruefer.getUmlaufszeit());
        daten.setEntdeckungbestaetigt(iPlanetensucheObjektPruefer.isEntdeckungBestaetigt());
        this.mapper.mapIds(iPlanetensucheObjektPruefer, daten);
        if (iPlanetensucheObjektPruefer.getUmkreistDatenId() != null) {
            daten.setZugehoerigkeit(iPlanetensucheObjektPruefer.getUmkreistDatenId());
        } else if (Check.isFilled(iPlanetensucheObjektPruefer.getUmkreistObjekt())) {
            Integer n = this.objektnamenRepository.readDatenid(iPlanetensucheObjektPruefer.getUmkreistObjekt());
            daten.setZugehoerigkeit(n);
        }
        return daten;
    }
}

