/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.Sternbild;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.cache.ISternbildSpracheCache;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.datenbankkern.querydsl5.QBilder;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QSternbilder;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.datenbankkern.querydsl5.Sternbilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SternbilderRepository
implements ISternbilderRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final ISternbildSpracheCache sternbildSpracheCache;
    private final QSternbilder qSternbilder = QSternbilder.sternbilder;
    private final IIdCacheDAO idCache;

    @Inject
    public SternbilderRepository(IDatenbankverbinder iDatenbankverbinder, ISternbildSpracheCache iSternbildSpracheCache, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.sternbildSpracheCache = iSternbildSpracheCache;
        this.idCache = iIdCacheDAO;
    }

    @Override
    public Integer getId(String string) throws SQLException {
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.id).from((Expression<?>)this.qSternbilder)).where(this.qSternbilder.latabk.eq(string))).fetchFirst();
        return n;
    }

    @Override
    public Sternbilder read(int n) throws SQLException {
        Sternbilder sternbilder = (Sternbilder)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder).from((Expression<?>)this.qSternbilder)).where(this.qSternbilder.id.eq(n))).fetchFirst();
        return sternbilder;
    }

    @Override
    public ISternbild getSternbild(String string) throws SQLException {
        Sternbilder sternbilder = (Sternbilder)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder).from((Expression<?>)this.qSternbilder)).where(this.qSternbilder.dtbezeichnung.eq(string).or(this.qSternbilder.engbezeichnung.eq(string)).or(this.qSternbilder.latabk.eq(string)).or(this.qSternbilder.latbezeichnung.eq(string)).or(this.qSternbilder.latgenitiv.eq(string)))).fetchOne();
        QBilder qBilder = QBilder.bilder;
        QZt qZt = QZt.zt;
        QNamen qNamen = QNamen.namen1;
        QDaten qDaten = QDaten.daten;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.idCache.getObjekttypenidsGalaxienundnebel());
        arrayList.addAll(this.idCache.getObjekttypenidsSternhaufen());
        arrayList.addAll(this.idCache.getObjekttypenidsGalaxienhaufen());
        arrayList.addAll(this.idCache.getObjekttypenidsSonstiges());
        List<String> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).join((EntityPath)qDaten)).on((Predicate)qNamen.datenid.eq(qDaten.id))).join((EntityPath)qZt)).on((Predicate)qZt.datenid.eq(qDaten.id))).where(qZt.sternbildid.eq(sternbilder.getId()).and(qDaten.objektid.in((Collection<Integer>)arrayList)))).groupBy((Expression<?>)qNamen.namen)).fetch();
        List<String> list2 = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qBilder.bild).from(new Expression[]{qBilder, qZt})).where(qZt.sternbildid.eq(sternbilder.getId()).and(qZt.bildid.eq(qBilder.id)))).fetch();
        Sternbild sternbild = new Sternbild();
        sternbild.setBilder(list2);
        sternbild.setObjekteImSternbild(list);
        sternbild.setSternbildBisDECL(sternbilder.getBisdecl());
        sternbild.setSternbildBisRA(sternbilder.getBisra());
        sternbild.setSternbildCode(sternbilder.getLatabk());
        sternbild.setSternbildDTBezeichnung(sternbilder.getDtbezeichnung());
        sternbild.setSternbildENGBezeichnung(sternbilder.getEngbezeichnung());
        sternbild.setSternbildGenitiv(sternbilder.getLatgenitiv());
        sternbild.setSternbildLATBezeichnung(sternbilder.getLatbezeichnung());
        sternbild.setSternbildVonDECL(sternbilder.getVondecl());
        sternbild.setSternbildVonRA(sternbilder.getVonra());
        return sternbild;
    }

    @Override
    public ISternbild getSternbildOnlyBasicData(String string) throws SQLException {
        Sternbilder sternbilder = (Sternbilder)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder).from((Expression<?>)this.qSternbilder)).where(this.qSternbilder.dtbezeichnung.eq(string).or(this.qSternbilder.engbezeichnung.eq(string)).or(this.qSternbilder.latabk.eq(string)).or(this.qSternbilder.latbezeichnung.eq(string)).or(this.qSternbilder.latgenitiv.eq(string)))).fetchOne();
        Sternbild sternbild = new Sternbild();
        sternbild.setSternbildBisDECL(sternbilder.getBisdecl());
        sternbild.setSternbildBisRA(sternbilder.getBisra());
        sternbild.setSternbildCode(sternbilder.getLatabk());
        sternbild.setSternbildDTBezeichnung(sternbilder.getDtbezeichnung());
        sternbild.setSternbildENGBezeichnung(sternbilder.getEngbezeichnung());
        sternbild.setSternbildGenitiv(sternbilder.getLatgenitiv());
        sternbild.setSternbildLATBezeichnung(sternbilder.getLatbezeichnung());
        sternbild.setSternbildVonDECL(sternbilder.getVondecl());
        sternbild.setSternbildVonRA(sternbilder.getVonra());
        return sternbild;
    }

    @Override
    public List<String> getSternbilderNamen(SternbildSprache sternbildSprache) throws SQLException {
        SternbildSprache sternbildSprache2 = sternbildSprache;
        if (sternbildSprache2 == null) {
            sternbildSprache2 = this.sternbildSpracheCache.getSternbildSprache();
        }
        List<String> list = SternbildSprache.DEUTSCH.equals((Object)sternbildSprache2) ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.dtbezeichnung).from((Expression<?>)this.qSternbilder)).orderBy((OrderSpecifier<?>)this.qSternbilder.dtbezeichnung.asc())).fetch() : (SternbildSprache.LATEINISCH.equals((Object)sternbildSprache2) ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.latbezeichnung).from((Expression<?>)this.qSternbilder)).orderBy((OrderSpecifier<?>)this.qSternbilder.latbezeichnung.asc())).fetch() : (SternbildSprache.ENGLISCH.equals((Object)sternbildSprache2) ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.engbezeichnung).from((Expression<?>)this.qSternbilder)).orderBy((OrderSpecifier<?>)this.qSternbilder.engbezeichnung.asc())).fetch() : (SternbildSprache.LATEINISCH_GENITIV.equals((Object)sternbildSprache2) ? ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.latgenitiv).from((Expression<?>)this.qSternbilder)).orderBy((OrderSpecifier<?>)this.qSternbilder.latgenitiv.asc())).fetch() : ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.latabk).from((Expression<?>)this.qSternbilder)).orderBy((OrderSpecifier<?>)this.qSternbilder.latabk.asc())).fetch())));
        return list;
    }

    @Override
    public String getSternbildGenitiv(String string) throws SQLException {
        return (String)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.latgenitiv).from((Expression<?>)this.qSternbilder)).where(this.qSternbilder.latabk.eq(string))).fetchFirst();
    }

    @Override
    public String getSternbildLateinisch(String string) throws SQLException {
        return (String)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.latbezeichnung).from((Expression<?>)this.qSternbilder)).where(this.qSternbilder.latabk.eq(string))).fetchFirst();
    }

    @Override
    public Integer getIdVonNamen(String string) throws SQLException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder.id).from((Expression<?>)this.qSternbilder)).where(this.qSternbilder.dtbezeichnung.eq(string).or(this.qSternbilder.engbezeichnung.eq(string).or(this.qSternbilder.latbezeichnung.eq(string))))).fetchFirst();
        return n;
    }

    @Override
    public List<ISternbild> findAll() {
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qSternbilder).from((Expression<?>)this.qSternbilder)).fetch();
        ArrayList<ISternbild> arrayList = new ArrayList<ISternbild>();
        for (Sternbilder sternbilder : list) {
            Sternbild sternbild = new Sternbild();
            sternbild.setId(sternbilder.getId());
            sternbild.setSternbildBisDECL(sternbilder.getBisdecl());
            sternbild.setSternbildBisRA(sternbilder.getBisra());
            sternbild.setSternbildCode(sternbilder.getLatabk());
            sternbild.setSternbildDTBezeichnung(sternbilder.getDtbezeichnung());
            sternbild.setSternbildENGBezeichnung(sternbilder.getEngbezeichnung());
            sternbild.setSternbildGenitiv(sternbilder.getLatgenitiv());
            sternbild.setSternbildLATBezeichnung(sternbilder.getLatbezeichnung());
            sternbild.setSternbildVonDECL(sternbilder.getVondecl());
            sternbild.setSternbildVonRA(sternbilder.getVonra());
            arrayList.add(sternbild);
        }
        return arrayList;
    }
}

