/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.repos;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.ISternbildSpracheCache;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.api.repos.IBilderRepository;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.querydsl5.Bilder;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.datenbankkern.querydsl5.Sternbilder;
import de.planetensuche.datenbankkern.querydsl5.Zt;
import de.planetensuche.datenbankkern.querydsl5.Ztentdecker;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class ZwischentabellenRepository
implements IZwischentabellenRepository {
    private final IDatenbankverbinder datenbankverbinder;
    private final IBilderRepository bilderRepository;
    private final ISternbilderRepository sternbilderRepository;
    private final QZt qZt = QZt.zt;
    private final QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
    private final IEntdeckerRepository entdeckerRepository;
    private final ISternbildSpracheCache sternbildSpracheCache;

    @Inject
    public ZwischentabellenRepository(IDatenbankverbinder iDatenbankverbinder, IBilderRepository iBilderRepository, ISternbilderRepository iSternbilderRepository, IEntdeckerRepository iEntdeckerRepository, ISternbildSpracheCache iSternbildSpracheCache) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.bilderRepository = iBilderRepository;
        this.sternbilderRepository = iSternbilderRepository;
        this.entdeckerRepository = iEntdeckerRepository;
        this.sternbildSpracheCache = iSternbildSpracheCache;
    }

    @Override
    public void save(Integer n, Integer n2, Set<String> set) throws SQLException {
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qZt).where((Predicate)this.qZt.datenid.eq(n2))).execute();
        if (n == null && Check.isEmpty(set)) {
            return;
        }
        if (Check.isEmpty(set)) {
            Zt zt = new Zt();
            zt.setDatenid(n2);
            zt.setSternbildid(n);
            zt.setBildid(null);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qZt).populate(zt)).execute();
            return;
        }
        for (String string : set) {
            Object object;
            Integer n3 = this.bilderRepository.getId(string);
            if (n3 == null) {
                object = new Bilder();
                ((Bilder)object).setBild(string);
                n3 = this.bilderRepository.create((Bilder)object);
            }
            object = new Zt();
            ((Zt)object).setDatenid(n2);
            ((Zt)object).setSternbildid(n);
            ((Zt)object).setBildid(n3);
            ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qZt).populate(object)).execute();
        }
    }

    @Override
    public void save(Integer n, Integer n2) throws SQLException {
        if (n == null) {
            throw new IllegalArgumentException("datenId is null");
        }
        if (n2 == null) {
            throw new IllegalArgumentException("entdeckerId is null");
        }
        Ztentdecker ztentdecker = new Ztentdecker();
        ztentdecker.setDatenid(n);
        ztentdecker.setEntdeckerid(n2);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qZtentdecker).populate(ztentdecker)).execute();
    }

    @Override
    public Set<String> getBilder(int n) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qZt).from((Expression<?>)this.qZt)).where(this.qZt.datenid.eq(n))).fetch();
        for (Zt zt : list) {
            Integer n2 = zt.getBildid();
            if (n2 == null) continue;
            Bilder bilder = this.bilderRepository.read(n2);
            hashSet.add(bilder.getBild());
        }
        return hashSet;
    }

    @Override
    public Sternbilder getSternbild(int n) throws SQLException {
        Zt zt = (Zt)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qZt).from((Expression<?>)this.qZt)).where(this.qZt.datenid.eq(n))).fetchFirst();
        if (zt == null) {
            return null;
        }
        Integer n2 = zt.getSternbildid();
        if (n2 == null) {
            return null;
        }
        return this.sternbilderRepository.read(n2);
    }

    @Override
    public List<Entdecker> getEntdecker(int n) throws SQLException {
        ArrayList<Entdecker> arrayList = new ArrayList<Entdecker>();
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qZtentdecker.entdeckerid).from((Expression<?>)this.qZtentdecker)).where(this.qZtentdecker.datenid.eq(n))).fetch();
        for (Integer n2 : list) {
            arrayList.add(this.entdeckerRepository.read(n2));
        }
        return arrayList;
    }

    @Override
    public void addBildFuerSternbild(String string, String string2) throws SQLException {
        Integer n = this.bilderRepository.getId(string2);
        Integer n2 = this.sternbilderRepository.getId(string);
        if (n == null) {
            throw new IllegalArgumentException("Bild '" + string2 + "' nicht gefunden!");
        }
        if (n2 == null) {
            throw new IllegalArgumentException("Sternbild '" + string + "' nicht gefunden!");
        }
        Zt zt = new Zt();
        zt.setSternbildid(n2);
        zt.setBildid(n);
        ((SQLInsertClause)this.datenbankverbinder.getNewSqlInsertClause(this.qZt).populate(zt)).execute();
    }

    @Override
    public void deleteEntdecker(Integer n) throws SQLException {
        ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qZtentdecker).where((Predicate)this.qZtentdecker.datenid.eq(n))).execute();
    }

    @Override
    public void getEntdeckerFuerObjektIds(List<Integer> list, List<String> list2, List<Integer> list3) throws SQLException {
        Object object;
        Object object22;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("no objects given!");
        }
        if (list2 == null || list3 == null) {
            throw new IllegalArgumentException("no fillable lists given!");
        }
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            int n = object3.next();
            List<Entdecker> iterator3 = this.getEntdecker(n);
            for (Object object22 : iterator3) {
                if (((Entdecker)object22).getTyp() != null && ((Entdecker)object22).getTyp().intValue() != EntdeckerTyp.PERSON.getType().intValue()) continue;
                object = ((Entdecker)object22).getVorname() + " " + ((Entdecker)object22).getNachname();
                if (treeMap.containsKey(object)) {
                    int n2 = (Integer)treeMap.get(object);
                    treeMap.put(object, n2 + 1);
                    continue;
                }
                treeMap.put(object, 1);
            }
        }
        object3 = new TreeMap();
        for (Map.Entry entry : treeMap.entrySet()) {
            int n = (Integer)entry.getValue();
            object22 = new ArrayList();
            if (object3.containsKey(n)) {
                object22.addAll((Collection)object3.get(n));
            }
            object22.add((String)entry.getKey());
            object3.put(n, object22);
        }
        TreeMap treeMap2 = new TreeMap();
        treeMap2.putAll(object3);
        Iterator iterator = treeMap2.descendingKeySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            object22 = (List)treeMap2.get(n);
            object = object22.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                list2.add(string);
                list3.add(n);
            }
        }
    }

    @Override
    public String getSternbildFuerDatenid(int n) throws SQLException {
        Integer n2 = (Integer)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qZt.sternbildid).from((Expression<?>)this.qZt)).where(this.qZt.datenid.eq(n))).limit(1L)).fetchFirst();
        if (n2 == null) {
            return "unbekannt";
        }
        Sternbilder sternbilder = this.sternbilderRepository.read(n2);
        if (sternbilder == null) {
            return "unbekannt";
        }
        if (SternbildSprache.ENGLISCH.equals((Object)this.sternbildSpracheCache.getSternbildSprache())) {
            return sternbilder.getEngbezeichnung();
        }
        if (SternbildSprache.LATEINISCH.equals((Object)this.sternbildSpracheCache.getSternbildSprache())) {
            return sternbilder.getLatbezeichnung();
        }
        return sternbilder.getDtbezeichnung();
    }
}

