/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.tabellenmanipulation;

import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import java.util.ArrayList;
import java.util.List;

public final class Create
extends Tabellenstruktur {
    private static final String CREATE_TABLE = "CREATE TABLE ";

    private Create() {
    }

    public static List<String> getTabellenCreateStatements() {
        ArrayList<String> arrayList = new ArrayList<String>(20);
        arrayList.add("CREATE TABLE dbversion (id IDENTITY, dbversion INTEGER);");
        arrayList.add("CREATE TABLE bilder (id IDENTITY, Bild VARCHAR(255) NOT NULL);");
        arrayList.add("CREATE TABLE Entdecker (id IDENTITY, Vorname VARCHAR(255), Nachname VARCHAR(255) NOT NULL, Fachgebiet VARCHAR(255), Typ INTEGER);");
        arrayList.add("CREATE TABLE entdeckungsmethode (id IDENTITY, Methode VARCHAR(255) NOT NULL);");
        arrayList.add("CREATE TABLE Sternbilder (id IDENTITY, dtbezeichnung VARCHAR(255), engbezeichnung VARCHAR(255), latbezeichnung VARCHAR(255), latabk VARCHAR(3), latgenitiv VARCHAR(255), vonRA DOUBLE, bisRA DOUBLE, vonDECL DOUBLE, bisDECL DOUBLE);");
        arrayList.add("CREATE TABLE kategorie (id IDENTITY, Name VARCHAR(255) NOT NULL);");
        arrayList.add("CREATE TABLE objekttypen (id IDENTITY, kategorieid INTEGER NOT NULL, Typ VARCHAR(255) NOT NULL, FOREIGN KEY (kategorieid) REFERENCES kategorie (id));");
        arrayList.add("CREATE TABLE galaxienform (id IDENTITY, Form VARCHAR(255));");
        arrayList.add("CREATE TABLE galaxienart (id IDENTITY, Art VARCHAR(255));");
        arrayList.add("CREATE TABLE sternhaufenform (id IDENTITY, oid INTEGER NOT NULL, Form VARCHAR(255), FOREIGN KEY (oid) REFERENCES objekttypen(id));");
        arrayList.add("CREATE TABLE nebelform (id IDENTITY, oid INTEGER NOT NULL, Form VARCHAR(255), FOREIGN KEY (oid) REFERENCES objekttypen(id));");
        arrayList.add("CREATE TABLE spektraltyp (id IDENTITY, kid INTEGER NOT NULL, Typ VARCHAR(9), FOREIGN KEY (kid) REFERENCES kategorie(id));");
        arrayList.add("CREATE TABLE spektraltyp2 (id IDENTITY, Typ DOUBLE);");
        arrayList.add("CREATE TABLE lumin (id IDENTITY, Typ VARCHAR(9));");
        arrayList.add("CREATE TABLE daten (id INTEGER GENERATED BY DEFAULT AS IDENTITY, Entfernung DOUBLE, Durchmesser DOUBLE, Durchmesser2 DOUBLE, Masse DOUBLE, Umlaufszeit DOUBLE, Exzentritaet DOUBLE, Entdeckungsdatum VARCHAR(10), Entdeckungsmethode INTEGER, EntdeckungBestaetigt BOOLEAN, RA DOUBLE, DECL DOUBLE, Objektid INTEGER NOT NULL, SH DOUBLE, AH DOUBLE, Flaechenhelligkeit DOUBLE, Temperatur DOUBLE, Geschwindigkeit DOUBLE, Spektralklasse INTEGER, Spektralklasse2 INTEGER, Lumin INTEGER, BV DOUBLE, Metallizitaet DOUBLE, Albedo DOUBLE, Galaxienform INTEGER, Galaxienart INTEGER, Sternentstehung Integer, Rotverschiebung DOUBLE, Sternhaufenform INTEGER, Nebelform INTEGER, Zugehoerigkeit INTEGER, entdeckungsjahr INTEGER, Autor VARCHAR(255) NOT NULL, STAMP TIMESTAMP NOT NULL, PRIMARY KEY (id), CONSTRAINT entdeckungsmethode_fk FOREIGN KEY (Entdeckungsmethode) REFERENCES entdeckungsmethode(id), CONSTRAINT objekttypen_fk FOREIGN KEY (Objektid) REFERENCES objekttypen(id), CONSTRAINT zugehoerigkeit_fk FOREIGN KEY (Zugehoerigkeit) REFERENCES daten(id), CONSTRAINT galaxienform_fk FOREIGN KEY (Galaxienform) REFERENCES galaxienform(id), CONSTRAINT galaxienart_fk FOREIGN KEY (Galaxienart) REFERENCES galaxienart(id), CONSTRAINT sternhaufenform_fk FOREIGN KEY (Sternhaufenform) REFERENCES sternhaufenform(id), CONSTRAINT nebelform_fk FOREIGN KEY (Nebelform) REFERENCES nebelform(id), CONSTRAINT sptyp_fk FOREIGN KEY (Spektralklasse) REFERENCES spektraltyp(id), CONSTRAINT sptyp2_fk FOREIGN KEY (Spektralklasse2) REFERENCES spektraltyp2(id), CONSTRAINT lumin_fk FOREIGN KEY (Lumin) REFERENCES lumin(id));");
        arrayList.add("CREATE TABLE zt (id IDENTITY, datenid INTEGER, sternbildid INTEGER, bildid INTEGER, FOREIGN KEY (datenid) REFERENCES daten(id) ON DELETE CASCADE, FOREIGN KEY (sternbildid) REFERENCES Sternbilder(id), FOREIGN KEY (bildid) REFERENCES bilder(id));");
        arrayList.add("CREATE TABLE ztentdecker (id IDENTITY, datenid INTEGER NOT NULL, entdeckerid INTEGER NOT NULL, FOREIGN KEY (datenid) REFERENCES daten(id) ON DELETE CASCADE, FOREIGN KEY (entdeckerid) REFERENCES Entdecker(id));");
        arrayList.add("CREATE TABLE namen (id IDENTITY, datenid INTEGER NOT NULL, Namen VARCHAR(255) NOT NULL, isBayerFlamsteedGcvs2 BOOLEAN DEFAULT false NOT NULL, isEigenname BOOLEAN DEFAULT false NOT NULL, FOREIGN KEY (datenid) REFERENCES daten(id) ON DELETE CASCADE);");
        arrayList.add("CREATE TABLE objektalter (id IDENTITY, datenid INTEGER NOT NULL, alter DOUBLE, UNIQUE(datenid), CONSTRAINT objektalterdatenid_fk FOREIGN KEY (datenid) REFERENCES daten(id) ON DELETE CASCADE);");
        arrayList.add("CREATE TABLE notizen (id IDENTITY, datenid INTEGER NOT NULL UNIQUE, notiz VARCHAR(1073741824) NOT NULL, FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
        arrayList.add("CREATE TABLE habitable_zone (id IDENTITY, datenid INTEGER NOT NULL UNIQUE, inner_hz DOUBLE NOT NULL, outer_hz DOUBLE NOT NULL, FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
        arrayList.add("CREATE TABLE pht_transit_matches (id IDENTITY, planet_id VARCHAR(30) NOT NULL UNIQUE, tic_id BIGINT NOT NULL, epoch_bjd DOUBLE NOT NULL, epoch_bjd_error DOUBLE NOT NULL, period_days DOUBLE, period_days_error DOUBLE, exofop_entry_created TIMESTAMP NOT NULL, checked BOOLEAN DEFAULT false NOT NULL, matched_subject_id BIGINT, exofop_state VARCHAR(10), user_comment VARCHAR(256));");
        arrayList.add("CREATE TABLE gaia_stars (id IDENTITY, datenid INTEGER NOT NULL UNIQUE, non_single VARCHAR(30) NULL, rv_error DOUBLE, ruwe DOUBLE, astro_ex_noise_sig DOUBLE, FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
        arrayList.add("CREATE CACHED TABLE pht_eb_candidates (tic_id BIGINT NOT NULL, datenid INTEGER NULL, auto_valid VARCHAR(30) DEFAULT 'TBD' NOT NULL, eb_catalog VARCHAR(30), PRIMARY KEY (tic_id), FOREIGN KEY (datenid) REFERENCES daten (id) ON DELETE CASCADE);");
        arrayList.add("CREATE CACHED TABLE pht_eb_candidate_tags (id BIGINT IDENTITY, subject_id BIGINT NOT NULL, tic_id BIGINT NOT NULL, tag_name VARCHAR(30) NOT NULL, count INTEGER NOT NULL, FOREIGN KEY (tic_id) REFERENCES pht_eb_candidates (tic_id) ON DELETE CASCADE);");
        arrayList.add("CREATE CACHED TABLE pht_eb_candidate_pages (id INTEGER GENERATED BY DEFAULT AS IDENTITY, tag_name VARCHAR(30) NOT NULL UNIQUE, current_page_no INTEGER NOT NULL, PRIMARY KEY (id));");
        arrayList.add("CREATE CACHED TABLE pht_eb_candidate_tce (tic_id BIGINT NOT NULL, period1 DOUBLE, period2 DOUBLE, period3 DOUBLE, period4 DOUBLE, period5 DOUBLE, period6 DOUBLE, target_offset1 DOUBLE, target_offset2 DOUBLE, target_offset3 DOUBLE, target_offset4 DOUBLE, target_offset5 DOUBLE, target_offset6 DOUBLE, num_sectors1 INTEGER, num_sectors2 INTEGER, num_sectors3 INTEGER, num_sectors4 INTEGER, num_sectors5 INTEGER, num_sectors6 INTEGER, PRIMARY KEY (tic_id));");
        return arrayList;
    }
}

