/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbankkern.impl.tabellenmanipulation;

import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Create;
import java.sql.SQLException;

public final class DatenbankSchemaGenerator {
    private final IDatenbankverbinder datenbankverbinder;

    public DatenbankSchemaGenerator(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
    }

    public void erstelleSchemaNeu() throws SQLException {
        this.entferneAlleTabellen();
        this.erstelleAlleTabellen();
        this.erstelleIndexes();
    }

    public void erstelleIndexes() throws SQLException {
        this.datenbankverbinder.query("DROP INDEX objektnamen IF EXISTS;");
        this.datenbankverbinder.query("CREATE INDEX idx_objektnamen_datenid ON namen (namen, datenid);");
        this.datenbankverbinder.query("DROP INDEX objektnamenids IF EXISTS;");
        this.datenbankverbinder.query("CREATE INDEX idx_objektnamen_id ON namen (namen, id);");
        this.datenbankverbinder.query("DROP INDEX entdeckerids IF EXISTS;");
        this.datenbankverbinder.query("CREATE INDEX idx_entdeckername_id ON Entdecker (nachname, id);");
        this.datenbankverbinder.query("DROP INDEX entdeckungsmethodenids IF EXISTS;");
    }

    public void erstelleAlleTabellen() throws SQLException {
        for (String string : Create.getTabellenCreateStatements()) {
            this.datenbankverbinder.query(string);
        }
    }

    public void entferneAlleTabellen() throws SQLException {
        String[] stringArray;
        for (String string : stringArray = new String[]{"objektalter", "namen", "ztentdecker", "zt", "daten", "bilder", "Entdecker", "entdeckungsmethode", "sternhaufenform", "nebelform", "spektraltyp", "spektraltyp2", "galaxienform", "galaxienart", "lumin", "objekttypen", "kategorie", "Sternbilder", "dbversion", "notizen", "habitable_zone", "pht_transit_matches", "gaia_stars"}) {
            this.datenbankverbinder.query("DROP TABLE " + string + " IF EXISTS;");
        }
    }
}

