/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung;

import de.planetensuche.formelsammlung.api.IKategoriezuweiser;
import de.planetensuche.formelsammlung.berechnungen.api.IFabrik;
import de.planetensuche.formelsammlung.berechnungen.bahngravitation.FabrikGravitation;
import de.planetensuche.formelsammlung.berechnungen.sonstiges.FabrikSonstiges;
import de.planetensuche.formelsammlung.berechnungen.sterne.FabrikSterne;
import de.planetensuche.formelsammlung.berechnungen.teleskope.FabrikTeleskope;
import de.planetensuche.formelsammlung.berechnungen.universum.FabrikUniversum;
import de.planetensuche.formelsammlung.berechnungen.zeitrechnung.FabrikZeitrechnung;
import de.planetensuche.formelsammlung.gui.api.IFormelAnzeige;
import de.planetensuche.formelsammlung.gui.bahngravitation.GravitationGuiCollector;
import de.planetensuche.formelsammlung.gui.sonstiges.OtherGuiCollector;
import de.planetensuche.formelsammlung.gui.sterne.StarGuiCollector;
import de.planetensuche.formelsammlung.gui.teleskope.TelescopesGuiCollector;
import de.planetensuche.formelsammlung.gui.universum.UniversumGuiCollector;
import de.planetensuche.formelsammlung.gui.zeit.TimeGuiCollector;
import java.util.ArrayList;
import java.util.List;

public final class Kategoriezuweiser
implements IKategoriezuweiser {
    private final List<IFabrik> fabriken = new ArrayList<IFabrik>();
    private final List<List<IFormelAnzeige>> kategorien;
    private final List<IFormelAnzeige> kategorieUniversum;
    private final List<IFormelAnzeige> kategorieSterne;
    private final List<IFormelAnzeige> kategorieGravitation;
    private final List<IFormelAnzeige> kategorieTeleskope;
    private final List<IFormelAnzeige> kategorieZeit;
    private final List<IFormelAnzeige> kategorieSonstiges;

    public Kategoriezuweiser() {
        this.fabriken.add(new FabrikUniversum());
        this.fabriken.add(new FabrikSterne());
        this.fabriken.add(new FabrikGravitation());
        this.fabriken.add(new FabrikTeleskope());
        this.fabriken.add(new FabrikZeitrechnung());
        this.fabriken.add(new FabrikSonstiges());
        this.kategorieUniversum = UniversumGuiCollector.createGuiList();
        this.kategorieSterne = StarGuiCollector.createGuiList();
        this.kategorieGravitation = GravitationGuiCollector.createGuiList();
        this.kategorieTeleskope = TelescopesGuiCollector.createGuiList();
        this.kategorieZeit = TimeGuiCollector.createGuiList();
        this.kategorieSonstiges = OtherGuiCollector.createGuiList();
        this.kategorien = new ArrayList<List<IFormelAnzeige>>();
        this.kategorien.add(this.kategorieUniversum);
        this.kategorien.add(this.kategorieSterne);
        this.kategorien.add(this.kategorieGravitation);
        this.kategorien.add(this.kategorieTeleskope);
        this.kategorien.add(this.kategorieZeit);
        this.kategorien.add(this.kategorieSonstiges);
    }

    @Override
    public IFormelAnzeige getFormelGUI(int n, String string) {
        List<IFormelAnzeige> list = this.kategorien.get(n);
        for (IFormelAnzeige iFormelAnzeige : list) {
            if (!string.equals(iFormelAnzeige.getName())) continue;
            return iFormelAnzeige;
        }
        throw new IllegalArgumentException("no formula found for ordinal " + n + " and name='" + string + "'");
    }

    private List<String> getFormelnamen(List<IFormelAnzeige> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (IFormelAnzeige iFormelAnzeige : list) {
            arrayList.add(iFormelAnzeige.getName());
        }
        return arrayList;
    }

    @Override
    public List<String> getFormelnFuerKategorie(int n) {
        return switch (n) {
            case 0 -> this.getFormelnamen(this.kategorieUniversum);
            case 1 -> this.getFormelnamen(this.kategorieSterne);
            case 2 -> this.getFormelnamen(this.kategorieGravitation);
            case 3 -> this.getFormelnamen(this.kategorieTeleskope);
            case 4 -> this.getFormelnamen(this.kategorieZeit);
            case 5 -> this.getFormelnamen(this.kategorieSonstiges);
            default -> throw new IllegalArgumentException("no formula found for ordinal " + n);
        };
    }

    @Override
    public IFabrik getFabrikFuerKategorie(int n) {
        return this.fabriken.get(n);
    }
}

