/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.bahngravitation;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnBahnGravitation;

public final class Gravitationsgesetz
extends Formel
implements IFormel {
    private double masseSternInKg;
    private double massePlanetInKg;
    private double mittlererBahnabstandInMeter;

    @Override
    public String berechne(boolean bl) {
        double d = 6.6742E-11 * this.masseSternInKg * this.massePlanetInKg / Math.pow(this.mittlererBahnabstandInMeter, 2.0);
        return Gravitationsgesetz.runden(bl, d);
    }

    @Override
    public String getName() {
        return FormelnBahnGravitation.GRAVITATIONSGESETZ.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.masseSternInKg = d;
        this.massePlanetInKg = dArray[0];
        this.mittlererBahnabstandInMeter = dArray[1] * 1000.0;
    }
}

