/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.bahngravitation;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnBahnGravitation;

public final class RadialkraftMitBahngeschwindigkeit
extends Formel
implements IFormel {
    private double masseInKg;
    private double radialgeschwindigkeitInMeterSekunde;
    private double mittlererBahnabstandInMeter;

    @Override
    public String berechne(boolean bl) {
        double d = this.masseInKg * Math.pow(this.radialgeschwindigkeitInMeterSekunde, 2.0) / this.mittlererBahnabstandInMeter;
        return RadialkraftMitBahngeschwindigkeit.runden(bl, d);
    }

    @Override
    public String getName() {
        return FormelnBahnGravitation.RADIALKRAFTBAHN.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.masseInKg = d;
        this.radialgeschwindigkeitInMeterSekunde = dArray[0];
        this.mittlererBahnabstandInMeter = dArray[1] * 1000.0;
    }
}

