/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.bahngravitation;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnBahnGravitation;

public final class RadialkraftMitUmlaufszeit
extends Formel
implements IFormel {
    private double masseInKg;
    private double umlaufszeitInSekunden;
    private double mittlererBahnabstandInMeter;

    @Override
    public String berechne(boolean bl) {
        return RadialkraftMitUmlaufszeit.runden(bl, this.masseInKg * 4.0 * Math.pow(Math.PI, 2.0) * this.mittlererBahnabstandInMeter / Math.pow(this.umlaufszeitInSekunden, 2.0));
    }

    @Override
    public String getName() {
        return FormelnBahnGravitation.RADIALKRAFTZEIT.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.masseInKg = d;
        this.umlaufszeitInSekunden = dArray[0] * 3.1536E7;
        this.mittlererBahnabstandInMeter = dArray[1] * 1000.0;
    }
}

