/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.sonstiges;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnSonstiges;

public final class Dichte
extends Formel
implements IFormel {
    private double masseInKg;
    private double durchmesserInKm;

    @Override
    public String berechne(boolean bl) {
        double d = this.masseInKg * 1000.0;
        double d2 = this.durchmesserInKm * 100000.0;
        double d3 = 0.5235987755982988 * Math.pow(d2, 3.0);
        return Dichte.runden(bl, d / d3);
    }

    @Override
    public String getName() {
        return FormelnSonstiges.DICHTE.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.masseInKg = d;
        this.durchmesserInKm = dArray[0];
    }
}

